/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalentry.cpp
*/
#include "normalentry.h"
#include <chunk.h>

normalEntry::normalEntry(double val, normal *nor):chunk()
{
	range=val;
	no=nor;
		
}

normalEntry::~normalEntry()
{
}

void	normalEntry::setNormalRange(double n)
{
	range=n;
}

double	normalEntry::getNormalRange()
{
	return range;
}

int	normalEntry::save(media *m)
{	
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving normalEntry\n");
	#endif
	setMedia(m);
	
	writeChunk("NRME");

	SD(range);
	no->save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("NormalEntry saved\n");
	#endif

	return 0;
}

int	normalEntry::load(media *m,int l)
{
	int i;
	char	chunk[4];
	int	len,pos = m->tell();

	if(!m)	return -1;
	i=0;

	setMedia(m);

	#ifdef DEBUG
		printf("loading normalEntry\n");
	#endif

	m->read(&range,sizeof(double));
	m->read(chunk,4);
	m->read(&len,4);

	if(strncmp(chunk,"NRME",4) == 0) {
		no=new normal();
		no->load(m,len);
	}

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("NormalEntry loaded\n");
	#endif

	return 0;
}

int		normalEntry::exportPOV(FILE *fp,int tab,int tabsize, int a)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting normalEntry (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"[ %g ",range);

	no->exportPOV(fp,tab+tabsize,tabsize,a,true);

	printTab(fp,tab);
	fprintf(fp,"]\n");
	#ifdef DEBUG
		printf("NormalEntry exported (POV)\n");
	#endif
	return 0;
}

