/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** cylinder.h
*/
#ifndef __CYLINDER_H__
#define __CYLINDER_H__

#include <classes.h>

class cylinder:public blobobj
{
public:

	cylinder(base *b=0,char *n="Untitled",double st=1,texture *t=0);
	cylinder(base *b,char *n,double st,Vector3&,Vector3&,Vector3&);
	cylinder(base *b,char *n,double st,texture *t,Vector3&,Vector3&,Vector3&);
	cylinder(base *b,cylinder *cc);
	~cylinder();

	virtual int	exportPOV(FILE *,int,int,int);
	virtual void	dumpNames(int,int);

	virtual int	addToParent(base *);
	virtual int	removeFromParent();

	virtual base	*copy(base*);

	virtual int	save(media*);
	virtual int	load(media*,int);

	virtual int	draw(view*,Matrix44,int);
	virtual int	calculate(int);

	virtual double	volume(int anim = 0);
};

#endif


