/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** cmeshtest.cpp
*/

#include "graph.cpp" 
#include "../../math/matmath.cpp" 

void	createBox(graph *g)
{
	int		ec = 0;
	knode		*kp[20];
	Vector3		x(1,0,0);
	Vector3		y(0,1,0);
	Vector3		z(0,0,1);

	kp[0] = new knode(g, x + y + z);
	kp[1] = new knode(g,-x + y + z);
	kp[2] = new knode(g,-x - y + z);
	kp[3] = new knode(g, x - y + z);
	kp[4] = new knode(g, x + y - z);
	kp[5] = new knode(g,-x + y - z);
	kp[6] = new knode(g,-x - y - z);
	kp[7] = new knode(g, x - y - z);

	new edge(g,kp[0],kp[1],ec++);
	new edge(g,kp[1],kp[2],ec++);
	new edge(g,kp[2],kp[3],ec++);
	new edge(g,kp[3],kp[0],ec++);
	new edge(g,kp[4],kp[5],ec++);
	new edge(g,kp[5],kp[6],ec++);
	new edge(g,kp[6],kp[7],ec++);
	new edge(g,kp[7],kp[4],ec++);
	new edge(g,kp[0],kp[4],ec++);
	new edge(g,kp[1],kp[5],ec++);
	new edge(g,kp[2],kp[6],ec++);
	new edge(g,kp[3],kp[7],ec++);
/*
	new edge(g,kp[0],kp[5],ec++);
	new edge(g,kp[5],kp[2],ec++);
	new edge(g,kp[2],kp[7],ec++);
	new edge(g,kp[7],kp[0],ec++);
	new edge(g,kp[0],kp[2],ec++);
	new edge(g,kp[4],kp[6],ec++);
*/
}

void	createDoubleRoof(graph *g)
{
	int		ec = 0;
	knode		*kp[20];
	Vector3		x(1,0,0);
	Vector3		y(0,1,0);
	Vector3		z(0,0,1);

	kp[0] = new knode(g, x + y);
	kp[1] = new knode(g,-x + y);
	kp[2] = new knode(g,-x - y);
	kp[3] = new knode(g, x - y);

	kp[4] = new knode(g,-z);
	kp[5] = new knode(g, z);

	new edge(g,kp[0],kp[1],ec++);
	new edge(g,kp[1],kp[2],ec++);
	new edge(g,kp[2],kp[3],ec++);
	new edge(g,kp[3],kp[0],ec++);

	new edge(g,kp[0],kp[4],ec++);
	new edge(g,kp[1],kp[4],ec++);
	new edge(g,kp[2],kp[4],ec++);
	new edge(g,kp[3],kp[4],ec++);

	new edge(g,kp[0],kp[5],ec++);
	new edge(g,kp[1],kp[5],ec++);
	new edge(g,kp[2],kp[5],ec++);
	new edge(g,kp[3],kp[5],ec++);
}

void	createRoof(graph *g)
{
	int		ec = 0;
	knode		*kp[20];
	Vector3		x(1,0,0);
	Vector3		y(0,1,0);
	Vector3		z(0,0,1);

	kp[0] = new knode(g, x + y);
	kp[1] = new knode(g,-x + y);
	kp[2] = new knode(g,-x - y);
	kp[3] = new knode(g, x - y);

	kp[4] = new knode(g,-z);

	new edge(g,kp[0],kp[1],ec++);
	new edge(g,kp[1],kp[2],ec++);
	new edge(g,kp[2],kp[3],ec++);
	new edge(g,kp[3],kp[0],ec++);

	new edge(g,kp[0],kp[4],ec++);
	new edge(g,kp[1],kp[4],ec++);
	new edge(g,kp[2],kp[4],ec++);
	new edge(g,kp[3],kp[4],ec++);
}

int	main()
{
	graph			*g;

/*
	list<int>		intlist;
	list<list<int> >	plist;

	int			i,t;

	intlist += 1;
	intlist += 2;
	intlist += 3;
	intlist += 4;
	intlist += 5;

	plist = intlist.power();
	for(i = 0;i < plist.length();i++)
	{
		printf("{");
		for(t = 0;t < plist[i].length();t++)
		{
			printf("%i",plist[i].at(t));
			if(t < plist[i].length() - 1)
				printf(",");
		}
		printf("}");
		if(i < plist.length() - 1)
			printf(",");
		else
			printf("\n");
	}
*/

	g = new graph();
	createRoof(g);
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	g->close();
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	delete g;

	g = new graph();
	createDoubleRoof(g);
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	g->close();
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	delete g;

	g = new graph();
	createBox(g);
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	g->close();
	printf("g is %sclose\n",(g->isClose()?"":"not "));
	delete g;



	return 0;
}

