/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** blobobj.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "blobobj.h"

blobobj::blobobj(base *p,const char *n,double st,texture *t) :
	csgobj(p,n,t)
{
	numtype = NUM_BLOBOBJ;
	strength = st;
}

blobobj::blobobj(base *p,const char *n,double st,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,vs,vr,vt)
{
	numtype = NUM_BLOBOBJ;
	strength = st;
}

blobobj::blobobj(base *p,const char *n,double st,texture *t,Vector3 &vs,Vector3 &vr,Vector3 &vt) :
	csgobj(p,n,t,vs,vr,vt)
{
	numtype = NUM_BLOBOBJ;
	strength = st;
}

blobobj::blobobj(base *p,blobobj *bc) :
	csgobj(p,(csgobj*)bc)
{
	numtype = NUM_BLOBOBJ;
	strength = bc->strength;
}

blobobj::~blobobj()
{
}

int	blobobj::isBlobObject()
{
	return (parent->getType() == NUM_BLOB);
}



