#!/bin/sh

if test $# -ge 3
then
	W=$2
	H=$3
else
	W=100
	h=100
fi

if test $# -ge 4
then
	F=$4
else
	F=50
fi

n=0
for i in $1
do
	n=`expr $n + 1`
	echo "Render frame " $n

	name=`basename $i .pov`

	echo "#declare LEFTEYE=1;" > left.pov
	echo "#declare f=$F;" >> left.pov
	echo "" >> left.pov
	cat $i >> left.pov
	povray +W$W +H$H +FP +Ileft.pov

	ppmtorgb3 left.ppm
	pgmtoppm rgb:ff/ff/ff left.red > left.r.ppm
	pgmtoppm rgb:ff/ff/ff left.grn > left.g.ppm
	pgmtoppm rgb:ff/ff/ff left.blu > left.b.ppm
	pnmarith -add  left.r.ppm left.g.ppm > left.rg.ppm
	pnmarith -add  left.rg.ppm left.b.ppm > left.rgb.ppm

	echo "#declare RIGHTEYE=1;" > right.pov
	echo "#declare f=$F;" >> right.pov
	echo "" >> right.pov
	cat $i >> right.pov
	povray +W$W +H$H +FP +Iright.pov

	ppmtorgb3 right.ppm
	pgmtoppm rgb:ff/ff/ff right.red > right.r.ppm
	pgmtoppm rgb:ff/ff/ff right.grn > right.g.ppm
	pgmtoppm rgb:ff/ff/ff right.blu > right.b.ppm
	pnmarith -add  right.r.ppm right.g.ppm > right.rg.ppm
	pnmarith -add  right.rg.ppm right.b.ppm > right.rgb.ppm

	ppmtorgb3 left.rgb.ppm
	ppmtorgb3 right.rgb.ppm
	pgmtoppm rgb:ff/00/00 left.rgb.grn > left.gray.g.ppm
	pgmtoppm rgb:00/ff/00 right.rgb.red > right.gray.r.ppm

	pnmarith -add left.gray.g.ppm right.gray.r.ppm > $name.ppm
	
	rm -f left.* right.*
done

