#ifndef __KWORMWIDGET_H_INCLUDED__
#define __KWORMWIDGET_H_INCLUDED__

#include <qwidget.h>
#include <kmenubar.h>

#include <qobject.h>
#include <qlcdnumber.h>

class CTimeWidget;
class CWormPlayground;
class CStartupScreen;

class KWormWidget : public QWidget
{
	Q_OBJECT

 public:
	KWormWidget(QWidget* parent = NULL);
	virtual ~KWormWidget();
	void resetTimer();
	QPixmap* getBackgroundPixmap();
	int speed() { return _speed; }

 protected:
	KMenuBar* _menuBar;
	QPopupMenu* _filemenu; // For enabling
	QPopupMenu* _speedMenu; // For checking
	QPopupMenu* _backgroundMenu; // "
	CWormPlayground* _playground;
	CStartupScreen* _startup;
	CTimeWidget* _timerBar;
	QLCDNumber* _scoreView;
	QLCDNumber* _livesView;

	int _speed;
	int _background;
	
	virtual void keyPressEvent(QKeyEvent* e);

	void makePlayground();
	void makeStartupScreen();
	void deletePlayground();
	void deleteStartupScreen();
	void resetStartupScreen(); // called after termination of the game and at the beginning

	// Only used when starting a new game
	QString _sLevel;
	int _nLevel;

 signals:
	void sigNewGame();
	void sigPauseGame(bool);
	void sigStopGame(char);
	void sigSpeedChanged(int);

 public slots:
	void slotTerminated();

 protected slots:
	// For menuitems only
	void slotNewGame();
        void slotPauseGame();
        void slotStopGame();
	void slotSelectLevel();
	void slotShowHighscores();

	void slotSpeed(int s);
	void slotBackground(int b);
	void slotMenuActive();
};
		
#endif // !__KWORMWIDGET_H_INCLUDED__
