
#include "main.h"
#include "kwormwidget.h"

#include "playground.h"
#include "startup.h"
#include "timewidget.h"
#include "d_level.h"
#include "d_highscore.h"

#include <qapplication.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <qmessagebox.h>
#include <qkeycode.h>

#include <stdio.h>

KWormWidget::KWormWidget(QWidget* parent) : QWidget(parent)
{
	_startup = NULL;
	_playground = NULL;
	_menuBar = ((KTMainWindow*) parent)->menuBar();

	/*QPopupMenu**/ _filemenu = new QPopupMenu;
	_filemenu->insertItem("&New Game",this,SLOT(slotNewGame()),Key_F2,0);
	_filemenu->insertItem("Select &Level",this,
			      SLOT(slotSelectLevel()),Key_S,1);
	_filemenu->insertItem("&Pause Game",this,
			      SLOT(slotPauseGame()),Key_F3,2);
	_filemenu->insertItem("&Stop Game",this,SLOT(slotStopGame()),Key_E,3);

	_filemenu->insertSeparator();
	_filemenu->insertItem("Show &Highscores",this,
			      SLOT(slotShowHighscores()));
	_filemenu->insertItem("&Quit",qApp,SLOT(quit()));
	
	_menuBar->insertItem("&File",_filemenu);

	QPopupMenu* settingsMenu = new QPopupMenu;

	/*QPopupMenu**/ _speedMenu = new QPopupMenu;
	_speedMenu->insertItem("&Slow");
	_speedMenu->insertItem("&Normal");
	_speedMenu->insertItem("&Quick");
	_speedMenu->setCheckable(true);
	connect(_speedMenu,SIGNAL(activated(int)),this,SLOT(slotSpeed(int)));
	settingsMenu->insertItem("&Speed",_speedMenu);

	/*QPopupMenu**/ _backgroundMenu = new QPopupMenu;
	_backgroundMenu->insertItem("&Random");
	for (int i = 0;i < _BackgroundArrayLen;i++) {
		_backgroundMenu->insertItem(*(_BackgroundArray[i]));
	}
	_backgroundMenu->setCheckable(true);
	connect(_backgroundMenu,SIGNAL(activated(int)),this,
		SLOT(slotBackground(int)));
	settingsMenu->insertItem("&Background",_backgroundMenu);

	_menuBar->insertItem("&Settings",settingsMenu);

	QPopupMenu* helpMenu = KApplication::getKApplication()->getHelpMenu(
                true,"KWorm 0.1, (C) 2000 by Michael Wand <mwand@gmx.de>");

	_menuBar->insertSeparator();
	_menuBar->insertItem("Help",helpMenu);

	_scoreView = new QLCDNumber(4,this);
	_scoreView->setGeometry(PGWIDTH * FDWIDTH - 60,10,60,40);
	
	_livesView = new QLCDNumber(1,this);
	_livesView->setGeometry(60,10,60,40);

	_timerBar = new CTimeWidget(this);
	_timerBar->setGeometry(0,10 + _scoreView->height(),20,
			       PGHEIGHT * FDHEIGHT);

	makeStartupScreen();
	resetStartupScreen();

	setFixedSize(_startup->width() + _timerBar->width(),_startup->height() + 10 + _scoreView->height());
	show();

	_sLevel = "std";
	_nLevel = 1;

	setFocusPolicy(QWidget::StrongFocus);

	slotBackground(0); // random
	slotSpeed(1); // normal
}

KWormWidget::~KWormWidget()
{
	if (QApplication::closingDown()) return;
	deleteStartupScreen();
	deletePlayground();
}

void KWormWidget::keyPressEvent(QKeyEvent* e)
{
	_playground->fwdKey(e);
}

void KWormWidget::makePlayground()
{
	ASSERT(_playground == NULL);

	_scoreView->show();
	_livesView->show();

	_playground = new CWormPlayground(this,_timerBar);
	_playground->setGeometry(_timerBar->width(),10 + _scoreView->height(),PGWIDTH * FDWIDTH,PGHEIGHT * FDHEIGHT);
	connect(_playground,SIGNAL(sigChangeScore(unsigned int)),_scoreView,SLOT(display(int)));
	connect(_playground,SIGNAL(sigTimer(long)),_timerBar,SLOT(slotTimer(long)));
	connect(_playground,SIGNAL(sigStart()),_timerBar,SLOT(slotStart()));
	connect(_playground,SIGNAL(sigRestart()),_timerBar,SLOT(slotStart()));
	connect(_playground,SIGNAL(sigDie(char)),_timerBar,SLOT(slotStop()));
	connect(_playground,SIGNAL(sigTerminate()),this,SLOT(slotTerminated()));
	connect(_playground,SIGNAL(sigLivesCount(int)),_livesView,SLOT(display(int)));
	connect(_timerBar,SIGNAL(sigTimeout()),_playground->maze(),SLOT(slotTimerBar()));
	connect(_menuBar,SIGNAL(highlighted(int)),this,SLOT(slotMenuActive()));

	_filemenu->setItemEnabled(2,true);
	_filemenu->setItemEnabled(3,true);

	_playground->show();
	_playground->setFocus();
}

void KWormWidget::makeStartupScreen()
{
	ASSERT(_startup == NULL);
	_startup = new CStartupScreen(this);
	_startup->setGeometry(_timerBar->width(),_scoreView->height(),PGWIDTH * FDWIDTH,PGHEIGHT * FDHEIGHT);
}

void KWormWidget::deletePlayground()
{
	delete _playground;
	_playground = NULL;
}

void KWormWidget::deleteStartupScreen()
{
	delete _startup;
	_startup = NULL;
}

void KWormWidget::resetStartupScreen()
{
	_filemenu->setItemEnabled(2,false);
	_filemenu->setItemEnabled(3,false);
	_timerBar->slotStop();
	_scoreView->hide();
	_livesView->hide();
	_startup->show();
}

void KWormWidget::resetTimer()
{
	_timerBar->reset();
}

QPixmap* KWormWidget::getBackgroundPixmap()
{
	if (_background) return _BackgroundArray[_background - 1];
	else return _BackgroundArray[rand() % _BackgroundArrayLen];
}

void KWormWidget::slotTerminated()
{
	deletePlayground();
	resetStartupScreen();
}

void KWormWidget::slotNewGame()
{
	if (_playground) { // Game is running
		emit sigPauseGame(true);
		if (QMessageBox::warning(NULL,"Warning","A game is already running. Start a new one?",
					 "Yes","No",NULL,1,1) == 1) return;
		emit sigStopGame(DieRestartCommand);
		ASSERT(!_playground);
	}
	makePlayground();
	_startup->hide();
	_playground->setLevel(_sLevel,_nLevel);
	emit sigNewGame();
}

void KWormWidget::slotPauseGame()
{
	emit sigPauseGame(false);
}

void KWormWidget::slotStopGame()
{
	emit sigStopGame(DieTerminateCommand);
}

void KWormWidget::slotSelectLevel()
{
	char snLevel[3];
	CLevelDialog dlg(this);
	dlg.setText(_sLevel);
	sprintf(snLevel,"%i",_nLevel);
	dlg.setNr(snLevel);
	if (dlg.exec() == QDialog::Accepted) {
		_sLevel = dlg.getText();
		_nLevel = atoi(dlg.getNr());
	}
	
}

void KWormWidget::slotShowHighscores()
{
	CHighscoreDialog dlg(this,0);
	dlg.initializeDialog();
	dlg.exec();      
}

void KWormWidget::slotSpeed(int s)
{
	switch(s) {
	case 0: _speed = 60; break;
	case 1: _speed = 50; break;
	case 2: _speed = 40; break;
	}
	_speedMenu->setItemChecked(0,false);
	_speedMenu->setItemChecked(1,false);
	_speedMenu->setItemChecked(2,false);
	_speedMenu->setItemChecked(s,true);
	emit sigSpeedChanged(_speed);
}

void KWormWidget::slotBackground(int b)
{
	for (int i = 0;i <= _BackgroundArrayLen;i++)
		_backgroundMenu->setItemChecked(i,false);
	_backgroundMenu->setItemChecked(b,true);
	_background = b;
}

void KWormWidget::slotMenuActive()
{
	emit sigPauseGame(true);
}
