#include "SolTable.moc"
#include "SolTable.h"

#include <ctime>  // Get rid of these and use c++ random...
#include <cmath>
#include <stdlib.h>
#include <stdio.h>

#include <qradiobt.h>
#include <qbttngrp.h>
#include <qpushbt.h>
#include <qmsgbox.h> 
#include <qfiledlg.h>
#include <kapp.h>

#define CARD_WIDTH 80
#define CARD_HEIGHT 120
#define TOT_CARDS 56
#define TOT_CARD_BACKS 4
#define FIRST_CARD_BACK 52
#define LAST_CARD_BACK 55
#define FIRST_ANI_FRAME 0
#define LAST_ANI_FRAME 0
                        
                        
#define TOT_OUTLINES 2
#define FIRST_OUTLINE 0
#define LAST_OUTLINE 1

#define MIN_PILE_D 5
#define MIN_PILE_SEP 15
#define MIN_PLAY_D 20
#define DECK_D 3

SolTable::SolTable(QWidget *par=NULL) :
  CardTable(1024, 768, par,0,0),
  cards(new Card*[52]),
  outlines(new Card*[13])
{
  QString tempstr1, tempstr2;

  /* LOAD CARDS, AND OUTLINE IMAGES */

  tempstr1 = kapp->kdedir();
  tempstr1 += "/share/apps/ksol/pics/ksol%d.ppm";
  tempstr2 = kapp->kdedir();
  tempstr2 += "/share/apps/ksol/pics/ksolmask.pbm";
  cardImages=new QwSpritePixmapSequence(tempstr1.data(),tempstr2.data(),TOT_CARDS);
  
  tempstr1 = kapp->kdedir();
  tempstr1 += "/share/apps/ksol/pics/ksoloutline%d.ppm";
  outlineImages=new QwSpritePixmapSequence(tempstr1,tempstr2,TOT_OUTLINES);

  /* START CONFIG */

  KConfig *config = kapp->getConfig();
  config->setGroup("ksol");

  tempstr1 = config->readEntry("Style");
  if (tempstr1 == "Vegas") gstyle = Vegas;
  else gstyle = Normal;

  tempstr1 = config->readEntry("DrawNum");
  if (tempstr1 == "DrawThree") dnum = DrawThree;
  else dnum = DrawOne;

  tempstr1 = kapp->kdedir();
  tempstr1 += "/share/apps/ksol/pics/background.xpm";
  background_image = config->readEntry("Background",tempstr1);
  setBackground(background_image);

  card_back_frame = config->readNumEntry("CardBackFrame",FIRST_CARD_BACK);
  outline_frame = config->readNumEntry("OutlineFrame",FIRST_OUTLINE);

  pile_w  = CARD_WIDTH;      /* These should be set by the card load...                   */
  pile_h  = CARD_HEIGHT;     
  calcCardLayout();  
                    
  dont_dbl=0;
  times_through_deck=1;
  game_won_card = -1;
  game_won_frame = FIRST_ANI_FRAME;

  /* Initialize the cards. */
  int i,j,k=0;
  CardSuit tempsuit;
  for (i=1; i<=4; i++) {

    if (i==1) { tempsuit = Hearts; }
    else if (i==2) { tempsuit = Diamonds; }
    else if (i==3) { tempsuit = Spades; }
    else {tempsuit = Clubs; }

    for (j=1; j<=13; j++) {
      cards[k] = new Card(*cardImages,PlayCard,j,tempsuit,k,card_back_frame);
      cards[k]->z(1);
      k++;
    }
  }  

  /* Initialize the outlines. */
  outlines[0] = new Card(*outlineImages,DeckOutline,NoSuit,NoNum,outline_frame,outline_frame);
  outlines[0]->setFace(0);
  outlines[0]->z(0);
  outlines[1] = new Card(*outlineImages,DrawOutline,NoSuit,NoNum,outline_frame,outline_frame);
  outlines[1]->z(0);
  outlines[1]->setFace(0);
  for (i=2;i<6;i++) {
    outlines[i] = new Card(*outlineImages,AcePileOutline,NoSuit,NoNum,outline_frame,outline_frame);
    outlines[i]->z(0);
    outlines[i]->setFace(0);
  }
  for (i=6;i<=12;i++) {
    outlines[i] = new Card(*outlineImages,PlayOutline,NoSuit,NoNum,outline_frame,outline_frame);
    outlines[i]->z(0);
    outlines[i]->setFace(0);
  }

  startTimer(REFRESH_DELAY);  
}

SolTable::~SolTable()
{
  delete[] cards;
  delete[] outlines;
  delete cardImages;
  delete outlineImages;
}

void SolTable::calcCardLayout()
{
  int temp;

  temp = (width() - 7*pile_w)/8;
  if (temp > MIN_PILE_D) pile_d = temp;
  else pile_d = MIN_PILE_D;

  if (pile_d < MIN_PILE_SEP) pile_sep = MIN_PILE_SEP;
  else pile_sep = pile_d;

  temp = (height() - pile_d*2 - pile_sep - 2*pile_h) / 12;
  if (temp < MIN_PLAY_D) play_d = MIN_PLAY_D;
  else play_d = temp;
}

void SolTable::resizeEvent(QResizeEvent* e)
{
  calcCardLayout();

  int i,pilepos,tz;

  outlines[0]->moveCardsTo(pile_d,pile_d);
  outlines[1]->moveCardsTo(pile_d+pile_w+pile_sep,pile_d);

  pilepos = pile_d*4 + pile_w*3;  
  for (i=2;i<=5;i++) outlines[i]->moveCardsTo(pilepos + (pile_d + pile_w)*(i-2), pile_d);

  pilepos = pile_d + pile_sep + pile_h;
  for (i=6;i<=12;i++) {
    outlines[i]->moveTo(pile_d + (pile_w + pile_d)*(i-6), pilepos);
    tz = outlines[i]->z()+1;
    if (!outlines[i]->isTopCard()) 
      (outlines[i]->nextCard())->dragCardsTo(pile_d+(pile_w+pile_d)*(i-6),pilepos,tz,0,play_d,1);
  }
  CardTable::resizeEvent(e);
}


void SolTable::checkGameWon()
{
  int i;
  char check=0;
  for (i=2;i<=5;i++)
    {
      if ((outlines[i]->topCard())->cardNum()==King) { check++; }
    }
  if (check==4) {
      game_won_card = 51;
      game_won_frame = FIRST_ANI_FRAME;
      emit undoable(0);
  }
}

void SolTable::setupScoring() {
  if (gstyle == Vegas) {
    scr_on_ace_pile = 5;
    scr_off_ace_pile = -5;
    scr_on_play_pile = 0;
    scr_through_deck = 0;
  }
  else {
    scr_on_ace_pile = 10;
    scr_off_ace_pile = -15;
    scr_on_play_pile = 5;
    if (dnum == DrawOne) scr_through_deck = -100;
    else scr_through_deck = -20;
  }
}

void SolTable::timerEvent(QTimerEvent *tev)
{
  if (game_won_card >= 0) {
    cards[game_won_card]->frame(game_won_frame);
    game_won_frame++;
    if (game_won_frame >= LAST_ANI_FRAME ) {
      game_won_frame = FIRST_ANI_FRAME;
      cards[game_won_card]->hide();

      game_won_card = game_won_card - 13;
      if (game_won_card < 0 && game_won_card > -13) { game_won_card = game_won_card + 51; }
      else if (game_won_card == -13) {
	emit gameWon(scr);
      }
    }
  }
  CardTable::timerEvent(tev);
  killTimers();
  startTimer(REFRESH_DELAY);
}

bool SolTable::altSuit(int suit1, int suit2)
{
  if (((suit1 == Hearts || suit1 == Diamonds) && (suit2 == Spades || suit2 == Clubs)) ||
      ((suit1 == Spades || suit1 == Clubs) && (suit2 == Hearts || suit2 == Diamonds)))
    { return 1; }
  return 0;
}

bool SolTable::startDragEvent(BaseCard *card)
{
  bool ok_to_start=0;

  switch (card->cardType()) {
  case PlayCard:
    ok_to_start = card->faceUp();
    break;
  case DrawCard:
    ok_to_start = card->isTopCard();
    break;
  case AcePileCard:
    ok_to_start = card->isTopCard();
    break;
  }
  return (ok_to_start && card->pickupCards());
}

bool SolTable::dragEvent(BaseCard *card, int nx, int ny)
{
  return card->dragCardsTo(nx,ny,100,0,play_d);
}

void SolTable::preDropEvent(BaseCard *card)
{
  pending_undo.reset();
  pending_undo.lowCard = card->prevCard();  
  pending_undo.hiCard = card;
  pending_undo.lastAction = SolUndo::CardToCard;
  pending_undo.old_score = scr;
}


bool SolTable::dropEvent(BaseCard *card, BaseCard *drop_on_card)
{
  bool temp=0;
  if (!drop_on_card) return 0; 

  switch (drop_on_card->cardType()) {
  case AcePileCard :
    if (card->cardNum() == drop_on_card->cardNum()+1 && 
	card->cardSuit() == drop_on_card->cardSuit() && card->isTopCard()
	&& card->dropCards(drop_on_card,0,0))
      { 
	scr += scr_on_ace_pile;

	card->setCardType(AcePileCard);
	checkGameWon();
	temp=1;
      }
    break;
  case AcePileOutline :
    if (card->cardNum() == Ace && card->isTopCard() &&	card->dropCards(drop_on_card,0,0))
      {
	if (card->cardType() != AcePileCard) {
	  scr += scr_on_ace_pile;
	  card->setCardType(AcePileCard);
	}

	checkGameWon();
	temp=1;
      }
    break;
  case PlayCard :
    if (card->faceUp() && card->cardNum() == drop_on_card->cardNum()-1 &&
	altSuit(card->cardSuit(),drop_on_card->cardSuit()) && 
	card->dropCards(drop_on_card,0,play_d)) 
      {
        switch (card->cardType()) {
	case DrawCard:
	  scr += scr_on_play_pile;
	  break;
	case AcePileCard:
	  scr += scr_off_ace_pile;
	  break;
	}
	card->setCardType(PlayCard);
	temp=1;
      }
    break;

  case PlayOutline:
    if (card->cardNum()==King && card->faceUp() && card->dropCards(drop_on_card,0,play_d))
      {
        switch (card->cardType()) {
	case DrawCard:
	  scr += scr_on_play_pile;
	  break;
	case AcePileCard:
	  scr += scr_off_ace_pile;
	  break;
	}

	/* Quick hack to position the cards properly. */
	card->pickupCards();
	card->dragCardsTo(card->x(),card->y()-play_d,card->z(),0,play_d);
	card->putdownCards();
	card->setCardType(PlayCard);
	temp=1;
      }
    break;
  }
  if (temp) 
    {
      emit score(scr);
      emit undoable(1);
      undo.reset();
      undo = pending_undo;
    }
  return temp;
}

void SolTable::dropFailedEvent(BaseCard *card)
{
  card->putbackCards();
}


void SolTable::clickEvent(BaseCard *card, int, int, int)
{
  dont_dbl=0;
  if (game_won_card >= 0) {
    int i;
    game_won_card = -1;
    for (i=0;i<52;i++) cards[i]->hide();
    emit gameWon(scr);
    return;
  }

  if (card && card->isTopCard()) {
    /* Flip cards. */
    if (card->cardType() == PlayCard && !card->faceUp())
      {

	emit undoable(1);
	undo.reset();
	undo.hiCard = card;
	undo.lastAction = SolUndo::Flip;

	card->setFace(1);
	dont_dbl=1;
      }
    else if (card->cardType() == DeckCard) 
      {
	emit undoable(1);
	undo.reset();
	undo.lastAction = SolUndo::DeckToDraw;
	
	outlines[1]->pickupCards();
	outlines[1]->dragCardsTo(outlines[1]->x(),outlines[1]->y(),0,0,0);
	outlines[1]->putdownCards();

	card->pickupCards();
	card->dropCards(outlines[1]->topCard(),0,0);
	card->setCardType(DrawCard);
	card->setFace(1);
	int i;
	for (i=2; i<=dnum; i++) {
	  BaseCard* tempcard = outlines[0]->topCard();
	  if (tempcard->cardType() == DeckCard) {
	    tempcard->pickupCards();
	    tempcard->dropCards(outlines[1]->topCard(),play_d,0);
	    tempcard->setCardType(DrawCard);
	    tempcard->setFace(1);
	  }
	}
	dont_dbl=1;
      }
  }
}

void SolTable::doubleClickEvent(BaseCard *card, int, int, int)
{
  if (!dont_dbl && card && card->isTopCard()) {
    if (card->cardType() == PlayCard || card->cardType() == DrawCard)
      {
	BaseCard *tempcard;
	bool done=0;
	int i=2;
	while (!done) {
	  tempcard = outlines[i]->topCard();
	  if ((card->cardNum()==tempcard->cardNum()+1 && card->cardSuit()==tempcard->cardSuit() &&
	       tempcard->cardType() == AcePileCard)
	      || (card->cardNum()==Ace && tempcard->cardType()==AcePileOutline))
	    {
	      emit undoable(1);
	      undo.old_score = scr;
	      if (card->cardType() != AcePileCard) {
		scr += scr_on_ace_pile;
		emit score(scr);
	      }

	      done=1;

	      undo.reset();
	      undo.hiCard = card;
	      undo.lowCard = card->prevCard();
	      undo.lastAction =  SolUndo::CardToCard;

	      card->pickupCards();
	      card->dropCards(tempcard,0,0);
	      card->setCardType(AcePileCard);
	      checkGameWon();
	    }
	  if (i++ == 6) { done = 1; }
	}
      }
    else if (gstyle == Normal && card->cardType() == DeckOutline) {

      emit undoable(0);
      undo.reset(); /* We don't undo these. */

      bool done=0;
      char count=0;
      
      if (times_through_deck >= dnum) scr += scr_through_deck;
      else times_through_deck++;
      emit score(scr);

      BaseCard *tc1 = outlines[0],
	*tc2 = outlines[1]->topCard(),
	*tc3;
      
      while (!done) {
	if (tc2->cardType() == DrawOutline) { done = 1; }
	else {
	  tc3 = tc2->prevCard();
	  tc2->pickupCards();
	  if (count % 5 == 4) {tc2->dropCards(tc1,DECK_D,DECK_D);}
	  else {tc2->dropCards(tc1,0,0);}
	  count++;
	  tc2->setFace(0);
	  tc2->setCardType(DeckCard);
	  tc1 = tc2;
	  tc2 = tc3;
	}
      }
    }
  }
}

void SolTable::deal()
{
  int i,j,temp,pilepos;
  bool dealer[52];

  /* Make sure no dependencies remain. */

  game_won_card = -1;
  for (i=0;i<52;i++) {
    cards[i]->cleanCard();
    cards[i]->show();
    dealer[i]=0;
  }

  for (i=0;i<=12;i++) outlines[i]->cleanCard();

  emit undoable(0);
  undo.reset();
  pending_undo.reset();

  /* Position deck, draw, and ace piles */
  outlines[0]->moveTo(pile_d,pile_d);
  outlines[1]->moveTo(pile_d+pile_w+pile_sep,pile_d);

  pilepos = pile_d*4 + pile_w*3;  
  for (i=2;i<=5;i++) outlines[i]->moveTo(pilepos + (pile_d + pile_w)*(i-2), pile_d);

  BaseCard *tempptr = outlines[0];

  srand(time(0));

  for (i=0;i<=23;i++) {
    /* Find a random card we haven't dealt yet. */
    temp = rand() % 52;
    while (dealer[temp]==1) { temp = rand() % 52; }
    dealer[temp]=1;
    cards[temp]->pickupCards();
    if (i % 5 == 4 ) {cards[temp]->dropCards(tempptr,DECK_D,DECK_D);}
    else {cards[temp]->dropCards(tempptr,0,0);}
    cards[temp]->setFace(0);
    tempptr = cards[temp]; 
    tempptr->setCardType(DeckCard);
  }

  /* Put cards on play piles. */
  pilepos = pile_d + pile_sep + pile_h;
  for (i=1;i<=7;i++) {

    outlines[i+5]->moveTo(pile_d + (pile_w + pile_d)*(i-1), pilepos);

    tempptr = outlines[i+5];
    for (j=1;j<=i;j++) {
      /* Find a random card we haven't dealt yet. */
      temp = rand() % 52;
      while (dealer[temp]==1) {	temp = rand() % 52; }      
      dealer[temp]=1;
      cards[temp]->pickupCards();
      if (j==1) cards[temp]->dropCards(tempptr,0,0);
      else cards[temp]->dropCards(tempptr,0,play_d);
      tempptr = cards[temp];
      tempptr->setCardType(PlayCard);
      if (j!=i) tempptr->setFace(0);
      else tempptr->setFace(1);
    }
  }

  emit score(scr);
}

void SolTable::_undo()
{
  switch (undo.lastAction) {
  case SolUndo::Flip:
    (undo.hiCard)->setFace(!(undo.hiCard->faceUp()));
    break;
  case SolUndo::DeckToDraw:
    BaseCard *tempcard1, *tempcard2;
    tempcard1 = outlines[1]->topCard();
    tempcard2 = outlines[0]->topCard();
    tempcard1->pickupCards();
    tempcard1->dropCards(tempcard2,0,0);
    tempcard1->setFace(0);
    tempcard1->setCardType(DeckCard);

    tempcard2 = tempcard1;
    if (dnum == DrawThree) {
      tempcard1 = outlines[1]->topCard();
      if (tempcard1->cardType() == DrawCard) {
	tempcard1->pickupCards();
	tempcard1->dropCards(tempcard2,0,0);
	tempcard1->setFace(0);
	tempcard1->setCardType(DeckCard);	
	
	tempcard2 = tempcard1;
	tempcard1 = outlines[1]->topCard();
	if (tempcard1->cardType() == DrawCard) {
	  tempcard1->pickupCards();
	  tempcard1->dropCards(tempcard2,0,0);
	  tempcard1->setFace(0);
	  tempcard1->setCardType(DeckCard);	
	}
      }
    }
    break;
  case SolUndo::CardToCard:
    scr = undo.old_score;
    (undo.hiCard)->pickupCards();
    switch ((undo.lowCard)->cardType()) {
    case AcePileOutline :
      (undo.hiCard)->dropCards(undo.lowCard,0,0);
      (undo.hiCard)->setCardType(AcePileCard);
      break;

    case AcePileCard :
      (undo.hiCard)->dropCards(undo.lowCard,0,0);
      (undo.hiCard)->setCardType(AcePileCard);
      break;

    case PlayOutline :
      (undo.hiCard)->dropCards(undo.lowCard,0,play_d);      
      (undo.hiCard)->pickupCards();
      (undo.hiCard)->dragCardsTo((undo.hiCard)->x(),
				  (undo.hiCard)->y()-play_d,
				  (undo.hiCard)->z(),0,play_d);
      (undo.hiCard)->putdownCards();
      (undo.hiCard)->setCardType(PlayCard);
      break;

    case PlayCard :
      (undo.hiCard)->dropCards(undo.lowCard,0,play_d);      
      (undo.hiCard)->setCardType(PlayCard);
      break;

    case DrawOutline :
      (undo.hiCard)->dropCards(undo.lowCard,0,0);      
      (undo.hiCard)->setCardType(DrawCard);
      break;

    case DrawCard :
      if (dnum == DrawOne) {(undo.hiCard)->dropCards(undo.lowCard,0,0);}
      else { (undo.hiCard)->dropCards(undo.lowCard,play_d,0); }
      (undo.hiCard)->setCardType(DrawCard);
      break;
    }
    break;
  case SolUndo::NoUndo:
    break;
  }

  emit undoable(0);
  undo.reset();
  pending_undo.reset();
  emit score(scr);
}

void SolTable::_deal()
{
  if (gstyle == Normal) scr=0;
  else scr -= 52;
  deal();
}

void SolTable::_newgame() 
{
  scr = 0;
  times_through_deck=1;
  setupScoring();
  _deal();
  emit newGameStarted(gstyle);
}


/**********************************************************************************************/

SolTableOptions::SolTableOptions(SolTable *parent) :
  QDialog(0,0,1)
{
  stbl = parent;

  temp_gstyle = stbl->gstyle;
  temp_dnum = stbl->dnum;
  temp_cb = stbl->card_back_frame;
  temp_ob = stbl->outline_frame;
  temp_back = stbl->background_image;

  
  /*           STYLES               */


  QButtonGroup *gs_group = new QButtonGroup(this, "Styles");
  gs_group->setTitle("Game Styles");
  gs_group->setGeometry(10,10,120,80);
  gs_group->setFrameStyle(QFrame::WinPanel | QFrame::Raised);

  QRadioButton *gs_buttons = new QRadioButton(gs_group);
  gs_buttons->setText("Normal");
  if (temp_gstyle == SolTable::Normal) { gs_buttons->setChecked(1); }
  gs_buttons->setGeometry(10,15,100,25);

  gs_buttons = new QRadioButton(gs_group);
  gs_buttons->setGeometry(10,45,100,25);
  gs_buttons->setText("Vegas");
  if (temp_gstyle == SolTable::Vegas) { gs_buttons->setChecked(1); }

  connect(gs_group,SIGNAL(clicked(int)),SLOT(gs_clicked(int)));


  /*           DRAW NUM               */

  QButtonGroup *dn_group = new QButtonGroup(this, "DrawNum");
  dn_group->setTitle("Draw Number");
  dn_group->setGeometry(140,10,120,80);
  dn_group->setFrameStyle(QFrame::WinPanel | QFrame::Raised);

  QRadioButton *dn_buttons = new QRadioButton(dn_group);
  dn_buttons->setText("Draw One");
  if (temp_dnum == SolTable::DrawOne) { dn_buttons->setChecked(1); }
  dn_buttons->setGeometry(10,15,100,25);
  dn_buttons = new QRadioButton(dn_group);
  dn_buttons->setGeometry(10,45,100,25);
  dn_buttons->setText("Draw Three");
  if (temp_dnum == SolTable::DrawThree) { dn_buttons->setChecked(1); }

  connect(dn_group,SIGNAL(clicked(int)),SLOT(dn_clicked(int)));


  /*           CARD BACKS               */

  QButtonGroup *cb_group = new QButtonGroup(this, "Card Backs");
  cb_group->setTitle("Change Cards");
  cb_group->setGeometry(10,100,120,55);
  cb_group->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
  
  QPushButton *imb = new QPushButton(cb_group);
  imb->setText("Next");
  imb->setGeometry(10,20,50,25);
  imb = new QPushButton(cb_group);
  imb->setText("Prev");
  imb->setGeometry(60,20,50,25);

  connect(cb_group,SIGNAL(clicked(int)),SLOT(cb_clicked(int)));


  /*           OUTLINES               */

  QButtonGroup *ob_group = new QButtonGroup(this, "Outlines");
  ob_group->setTitle("Change Outlines");
  ob_group->setGeometry(140,100,120,55);
  ob_group->setFrameStyle(QFrame::WinPanel | QFrame::Raised);
  
  QPushButton *omb = new QPushButton(ob_group);
  omb->setText("Next");
  omb->setGeometry(10,20,50,25);
  omb = new QPushButton(ob_group);
  omb->setText("Prev");
  omb->setGeometry(60,20,50,25);

  connect(ob_group,SIGNAL(clicked(int)),SLOT(ob_clicked(int)));


  /*           BACKGROUND               */

  QButtonGroup *back_group = new QButtonGroup(this, "Background");
  back_group->setTitle("Change Background");
  back_group->setGeometry(65,170,140,55);
  back_group->setFrameStyle(QFrame::WinPanel | QFrame::Raised);

  QPushButton *backbut = new QPushButton(back_group);
  backbut->setText("Select File");
  backbut->setGeometry(10,20,120,25);

  connect(back_group,SIGNAL(clicked(int)),SLOT(backbut_clicked(int)));


  /*           OK/CANCEL               */

  QButtonGroup *end_group = new QButtonGroup(this, "end");
  end_group->setGeometry(10,250,290,40);
  end_group->setFrameStyle(QFrame::NoFrame);

  QPushButton *pbtn = new QPushButton(end_group);
  pbtn->setText("OK");
  pbtn->setGeometry(45,10,50,25);
  pbtn = new QPushButton(end_group);
  pbtn->setText("Save");
  pbtn->setGeometry(105,10,50,25);
  pbtn = new QPushButton(end_group);
  pbtn->setText("Cancel");
  pbtn->setGeometry(165,10,50,25);

  connect(end_group,SIGNAL(clicked(int)),SLOT(end_clicked(int)));

  setFixedSize(270,300);
}

SolTableOptions::~SolTableOptions()
{}

void SolTableOptions::gs_clicked(int id)
{
  if (id==0) { temp_gstyle = SolTable::Normal; }
  else { temp_gstyle = SolTable::Vegas; }
}

void SolTableOptions::dn_clicked(int id)
{
  if (id==0) { temp_dnum = SolTable::DrawOne; }
  else { temp_dnum = SolTable::DrawThree; }
}

void SolTableOptions::end_clicked(int id)
{
  int i;
  if (id == 0 || id == 1) {  /* OK , or SAVE */

    bool newgame_needed = stbl->gstyle != temp_gstyle || stbl->dnum != temp_dnum;

    stbl->gstyle = temp_gstyle;
    stbl->dnum = temp_dnum;
    stbl->card_back_frame = temp_cb;
    stbl->outline_frame = temp_ob;
    stbl->background_image = temp_back;

    if (id == 1) {
      KConfig *temp_config = kapp->getConfig();
      temp_config->setGroup("ksol");

      if (temp_gstyle == 0)
	temp_config->writeEntry("Style","Normal");
      else
	temp_config->writeEntry("Style","Vegas");

      if (temp_dnum == 1)
	temp_config->writeEntry("DrawNum","DrawOne");
      else
	temp_config->writeEntry("DrawNum","DrawThree");

      temp_config->writeEntry("CardBackFrame",temp_cb);
      temp_config->writeEntry("OutlineFrame",temp_ob);
      temp_config->writeEntry("Background",temp_back);
      temp_config->sync();
    }
    
    done(newgame_needed);

  }
  else {    
    if (temp_back != stbl->background_image) stbl->setBackground(stbl->background_image);
    if (temp_cb != stbl->card_back_frame) {
      int i;
      temp_cb = stbl->card_back_frame;
      for (i=0;i<52;i++) stbl->cards[i]->setFacedownFrame(temp_cb);
    }
    if (temp_ob != stbl->outline_frame) {
      temp_ob = stbl->outline_frame;
      for (i=0;i<13;i++) stbl->outlines[i]->setFacedownFrame(temp_ob);
    }
    done(0);
  }
    
}

void SolTableOptions::cb_clicked(int id)
{
  if (id == 1) {
    if (temp_cb > FIRST_CARD_BACK) temp_cb--;
    else temp_cb = LAST_CARD_BACK;
  }
  else {
    if (temp_cb < LAST_CARD_BACK) temp_cb++;
    else temp_cb = FIRST_CARD_BACK;
  }
  int i;
  for (i=0;i<52;i++) stbl->cards[i]->setFacedownFrame(temp_cb);
}

void SolTableOptions::ob_clicked(int id)
{
  if (id == 1) {
    if (temp_ob > FIRST_OUTLINE) temp_ob--;
    else temp_ob = LAST_OUTLINE;
  }
  else {
    if (temp_ob < LAST_OUTLINE) temp_ob++;
    else temp_ob = FIRST_OUTLINE;
  }
  int i;
  for (i=0;i<13;i++) stbl->outlines[i]->setFacedownFrame(temp_ob);
}

void SolTableOptions::backbut_clicked(int) 
{
  temp_back = QFileDialog::getOpenFileName(0,"*",0,temp_back);

  if (!temp_back.isEmpty()) {
    if (!stbl->setBackground(temp_back.data())) {
      QMessageBox::message("Invalid Background Image",
			 "The selected file was invalid.  Background not changed.");
    }
    else return;
  }
  temp_back = stbl->background_image;		      
}



