/***************************************************************************
                          puzzlewidget.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "puzzlewidget.h"

extern int revealword_id;

PuzzleWidget::PuzzleWidget(QWidget * parent, const char * name) : QWidget(parent,name){
// defaults
	this -> setFocusPolicy (QWidget::StrongFocus);
	square_size = 30;

	fn_x = 3; fn_y = 12; fn2_x = 15; fn2_y = 25; x_old = 0; y_old = 0;

	mouse_pressed = FALSE; horizontal_dir = TRUE;
	this -> resize (300,300);
}

bool PuzzleWidget::beginWord(int x,int y)
{
    bool ret;
    if (!horizontal_dir)
        if (part(x,y - 1) == '.' && part(x,y) != '.' && part(x,y + 1) != '.')
            ret = TRUE;
        else
            ret =  FALSE;
    if (horizontal_dir)
        if (part(x - 1,y) == '.' && part(x,y) != '.' && part(x + 1,y) != '.')
            ret = TRUE;
        else
            ret = FALSE;
    return ret;
}

void PuzzleWidget::clickNextWord()
{
    int x = x_old;
    int y = y_old;
    if (!horizontal_dir)
    {
        for ( y = y_old; y >= 0 ; y--)
            if ( part(x,y) == '.')
                break;
        y++;
    }
    else
        y = y_old;
    x++;
    if (x == puzzle.width)
    {
        x = 0;
        y++;
    }
    while (!beginWord(x,y))
    {
        x++;
        if (x == puzzle.width)
        {
            x = 0;
            y++;
        }
        if (y == puzzle.height)
            y = 0;
    }
    leftClick(x,y);
}

void PuzzleWidget::computeNumbers()
{
    int counter = 1;
    int counter_down = 0;
    int counter_across = 0;
    for (int y = 0; y <= puzzle.height - 1; y++)
        for (int x = 0 ; x <= puzzle.width - 1; x++)
        {
            if (part(x,y - 1) == '.' && part(x,y) != '.' && part(x,y + 1) != '.')
            {
                number[x][y] = counter;
                counter++;
            }
            else if (part(x - 1,y) == '.' && part(x,y) != '.' && part(x + 1,y) != '.')
            {
                number[x][y] = counter;
                counter++;
            }
            else number[x][y] = 0;
        }
    for (int y = 0; y <= puzzle.height - 1; y++)
        for (int x = 0 ; x <= puzzle.width - 1; x++)
        {
            if (part(x,y - 1) == '.' && part(x,y) != '.' && part(x,y + 1) != '.' && number[x][y] > 0)
            {
                if (counter_down < puzzle.downumber)
                    puzzle.down_question_number [counter_down] = number[x][y] ;
                counter_down++;
            }
            if (part(x - 1,y) == '.' && part(x,y) != '.' && part(x + 1,y) != '.' && number[x][y] > 0)
            {
                if (counter_across < puzzle.acrnumber)
                    puzzle.across_question_number[counter_across] = number[x][y];
                counter_across++;
            }
        }
    if (counter_across != puzzle.acrnumber || counter_down != puzzle.downumber)
        KMsgBox::message(0,"","Number of questions don't match puzzle");
}

void PuzzleWidget::flipDir()
{
    if (horizontal_dir == TRUE)
        horizontal_dir = FALSE;
    else horizontal_dir = TRUE;
}

void PuzzleWidget::keyPressEvent(QKeyEvent * k)
{
    if (mouse_pressed)
    {
        int kc = k -> key();
        if (kc == 4114)
        {
            if (horizontal_dir)
                leftClick(prevX(),y_old);
            else
            {
                horizontal_dir = TRUE;
                leftClick(x_old,y_old);
            }
        }
        if (kc == 4116)
            if (horizontal_dir)
                leftClick(nextX(), y_old);
            else
            {
                horizontal_dir = TRUE;
                leftClick(x_old,y_old);
            }
        if (kc == 4115)
            if (!horizontal_dir)
                leftClick(x_old, prevY());
            else
            {
                horizontal_dir = FALSE;
                leftClick(x_old,y_old);
            }
        if (kc == 4117)
            if (!horizontal_dir)
                leftClick(x_old, nextY());
            else
            {
                horizontal_dir = FALSE;
                leftClick(x_old,y_old);
            }
        if (kc == 4099 || kc == 4103)
            removeLetter();
        if (kc == 32)
            if (edit_mode)
            {
                makeBlack(x_old,y_old);
                if (horizontal_dir)
                {
                    x_old++;
                    leftClick(x_old,y_old);
                }
                else
                {
                    y_old++;
                    leftClick(x_old,y_old);
                }
                puzzle.changed = TRUE;
            }
        if (kc >= 65 && kc <= 90)
            typeLetter((char)kc);
        if (kc == 4100)
            clickNextWord();
    }
}

int PuzzleWidget::prevX()
{
    int x = x_old - 1;
    int y = y_old;
    while (part(x,y) == '.')
    {
        x--;
        if (x < 0)
        {
            x = x_old;
            break;
        }
    }
    return x;
}

int PuzzleWidget::nextX()
{
    int x = x_old + 1;
    int y = y_old;
    while (part(x,y) == '.')
    {
        x++;
        if (x >= puzzle.width)
        {
            x = x_old;
            break;
        }
    }
    return x;
}

int PuzzleWidget::prevY()
{
    int x = x_old;
    int y = y_old - 1;
    while (part(x,y) == '.')
    {
        y--;
        if (y < 0)
        {
            y = y_old;
            break;
        }
    }
    return y;
}

int PuzzleWidget::nextY()
{
    int x = x_old;
    int y = y_old + 1;
    while (part(x,y) == '.')
    {
        y++;
        if (y >= puzzle.height)
        {
            y = y_old;
            break;
        }
    }
    return y;
}

void PuzzleWidget::leftClick(int x, int y)
{
    leftClickRemove(x_old,y_old);
    if (onPuzzle(x,y) && !onBlack(x,y))
    {
        mouse_pressed = TRUE;
        emit solutionmenu_enable(revealword_id,TRUE);
        x_old = x; y_old = y;
        int i = x ; int j = y;
        while (part(i - 1,j) != '.' )
        {
            i--;
            if (horizontal_dir)
                drawFrame(i,j,red,lightGray);
        }
        if (!edit_mode)
            emit questions_widget_select(across_question_number_inv(number[i][y]),TRUE,TRUE);
        i = x;
        while (part(i + 1,j) != '.' )
        {
            i++;
            if (horizontal_dir)
                drawFrame(i,j,red,lightGray);
        }
        i = x ; j = y;
        while (part(i,j - 1) != '.' )
        {
            j--;
            if (!horizontal_dir)
                drawFrame(i,j,red,lightGray);
        }
        if (!edit_mode)
            emit questions_widget_select(down_question_number_inv(number[x][j]),TRUE,FALSE);
        j = y ;
        while (part(i,j + 1) != '.' )
        {
            j++;
            if (!horizontal_dir)
                drawFrame(i,j,red,lightGray);
        }
        drawFrame(x,y,red,gray);
    }
    else
        mouse_pressed = FALSE;
}

int PuzzleWidget::across_question_number_inv(int q)
{
    int ret = -1;
    for (int i=0; i <=puzzle.acrnumber - 1; i++)
        if (puzzle.across_question_number[i] == q)
            ret = i;
    return ret;
}

int PuzzleWidget::down_question_number_inv(int q)
{
    int ret = -1;
    for (int i=0; i <=puzzle.downumber - 1; i++)
        if (puzzle.down_question_number[i] == q)
            ret = i;
    return ret;
}

void PuzzleWidget::leftClickRemove(int x, int y)
{
    if (mouse_pressed && part(x,y) != '.')
    {
        emit solutionmenu_enable(revealword_id,FALSE);
        int i = x;  int j = y;
        while (part(i - 1,j) != '.' )
        {
            i--; drawFrame(i,j,black,white);
        }
        i = x;
        while (part(i + 1,j) != '.'  )
        {
            i++; drawFrame(i,j,black,white);
        }
        i = x; j = y;
        while (part(i,j - 1) != '.' )
        {
            j--; drawFrame(i,j,black,white);
        }
        j = y;
        while (part(i,j + 1) != '.' )
        {
            j++; drawFrame(i,j,black,white);
        }
        drawFrame(x,y,black,white);
    }
}

void PuzzleWidget::drawFrame(unsigned int x,unsigned int y, QColor o,QColor i)
{
    QPainter p;
    p.begin(this);
    p.setBrush(i);
    p.setPen(o);
    p.drawRect(x * square_size, y * square_size ,square_size + 1, square_size + 1);
    p.setPen(black);
    if (number[x][y] > 0 && !edit_mode)
    {
        QString nr;
        nr.setNum(number[x][y]);
        p.drawText(x * square_size + fn_x, y * square_size + fn_y, nr);
    }
    if (puzzle.solution[y][x] != '.')
    {
        if (puzzle.reveal[y][x] == 'T' && !edit_mode)
        {
            p.setPen(red);
            p.drawText(x * square_size + fn2_x, y *square_size + fn2_y,puzzle.solution[y].mid(x,1));
        }
        else
        {
            p.setPen(blue);
            if (!edit_mode)
            {
                p.drawText(x * square_size + fn2_x, y *square_size + fn2_y,puzzle.solve[y].mid(x,1));
                if (puzzle.solve[y][x] != puzzle.solution[y][x] && puzzle.solve[y][x] != ' ' && ShowLetterCorr_bl )
                {
                    p.setPen(red);
                    p.drawLine(x * square_size,y *square_size ,(x + 1) * square_size,(y + 1) *square_size);
                }
                if (!wordCorrect(x,y) && ShowWordCorr_bl)
                {
                    p.setPen(red);
                    p.drawLine(x * square_size,y *square_size ,(x + 1) * square_size,(y + 1) *square_size);
                    p.drawLine((x + 1)* square_size,y *square_size ,x * square_size,(y + 1) *square_size);
                }
            }
            if (edit_mode)
                p.drawText(x * square_size + fn2_x, y *square_size + fn2_y,puzzle.solution[y].mid(x,1));
        }
    }
    p.end();
}

void PuzzleWidget::focusInEvent(QFocusEvent *)
{
}

void PuzzleWidget::focusOutEvent(QFocusEvent *)
{
}

void PuzzleWidget::makeBlack(int x, int y)
{
    if ( onPuzzle(x,y) )
    {
        leftClickRemove(x_old,y_old);
        if (part(x,y)=='.')
        {
            puzzle.solution[y][x] = ' ';
            drawFrame(x,y,black,white);
        }
        else
        {
            puzzle.solution[y][x] = '.';
                drawFrame(x,y,black,black);
        }
    }
}

bool PuzzleWidget::onPuzzle(int x,int y)
{
    if (x >= 0 && y >= 0 && x < puzzle.width && y < puzzle.height)
        return TRUE;
    else return FALSE;
}

bool PuzzleWidget::onBlack(int x,int y)
{
    if (part(x,y) == '.')
        return TRUE;
    else return FALSE;
}

bool PuzzleWidget::onWhite(int x,int y)
{
    if ( part(x,y) != '.')
        return TRUE;
    else
        return FALSE;
}

void PuzzleWidget::paintEvent(QPaintEvent* e)
{
    QRect updateR = e -> rect();
    for (int x = 0; x < puzzle.width; x++)
        for (int y = 0; y < puzzle.height; y++)
        {
            if (updateR.intersects (QRect( x* square_size, y*square_size, square_size, square_size)))
                {
                    if (part(x,y) == '.')
                        drawFrame(x,y,black,black);
                    else
                        drawFrame(x,y,black,white);
                }
        }
    if (mouse_pressed)
        leftClick(x_old,y_old);
}

char PuzzleWidget::part(int x,int y)
{
    if (onPuzzle(x,y))
        return puzzle.solution[y][x];
    else return '.';
}

void PuzzleWidget::revealWord()
{
    puzzle.changed = TRUE;
    int i = x_old ; int j = y_old;
    while (part(i - 1,j) != '.' )
    {
        i--;
        if (horizontal_dir)
            puzzle.reveal[j][i] = 'T';
    }
    i = x_old;
    while (part(i + 1,j) != '.' )
    {
        i++;
        if (horizontal_dir)
            puzzle.reveal[j][i] = 'T';
    }
    i = x_old ; j = y_old;
    while (part(i,j - 1) != '.' )
    {
        j--;
        if (!horizontal_dir)
            puzzle.reveal[j][i] = 'T';
    }
    j = y_old ;
    while (part(i,j + 1) != '.' )
    {
        j++;
        if (!horizontal_dir)
            puzzle.reveal[j][i] = 'T';
    }
    puzzle.reveal[y_old][x_old] = 'T';
    leftClick(x_old,y_old);
}

void PuzzleWidget::removeLetter()
{
    puzzle.changed = TRUE;
    if (edit_mode)
        puzzle.solution[y_old][x_old]=' ';
    if (!edit_mode)
        puzzle.solve[y_old][x_old]=' ';
    leftClick(x_old,y_old);
}

void PuzzleWidget::typeLetter(char kc)
{
    puzzle.changed = TRUE;
    if (!edit_mode)
        puzzle.solve[y_old][x_old] = kc;
    if (edit_mode)
        puzzle.solution[y_old][x_old] = kc;
    drawFrame(x_old,y_old,red,gray);
    if (horizontal_dir)
        if (onWhite(x_old + 1,y_old))
            leftClick(x_old + 1, y_old);
        else
            leftClick(x_old,y_old);

    if (!horizontal_dir)
        if (onWhite(x_old, y_old + 1))
            leftClick (x_old, y_old + 1);
        else
            leftClick(x_old,y_old);
}

void PuzzleWidget::mousePressEvent(QMouseEvent * m)
{
    int x = m -> x();
    int y = m -> y();
    x = int (x / square_size);
    y = int ((y ) / square_size);
    if (m -> button() == LeftButton)
    {
        if (x == x_old && y == y_old)
            flipDir();
        leftClick(x,y);
    }
    if (m -> button() == RightButton)
    {
        if (edit_mode)
        {
            makeBlack(x,y);
            puzzle.changed = TRUE;
        }
    }
}

bool PuzzleWidget::wordCorrect(int x, int y)
{
    bool RetVal,RetValHor,RetValVer,SpaceHor,SpaceVer;
    RetVal = RetValHor = RetValVer = TRUE;
    SpaceHor = SpaceVer = FALSE;
    int i = x ; int j = y;
    while (part(i ,j) != '.' )
    {
        if (puzzle.solution[j][i] != puzzle.solve[j][i])
            RetValHor = FALSE;
        if (puzzle.solve[j][i] == ' ')
            SpaceHor = TRUE;
        i--;
    }
    i = x;
    while (part(i ,j) != '.' )
    {
        if (puzzle.solution[j][i] != puzzle.solve[j][i])
            RetValHor = FALSE;
        if (puzzle.solve[j][i] == ' ')
            SpaceHor = TRUE;
        i++;
    }
    i = x ; j = y;
    while (part(i,j ) != '.' )
    {
        if (puzzle.solution[j][i] != puzzle.solve[j][i])
            RetValVer = FALSE;
        if (puzzle.solve[j][i] == ' ')
            SpaceVer = TRUE;
        j--;
    }
    j = y;
    while (part(i,j ) != '.' )
    {
        if (puzzle.solution[j][i] != puzzle.solve[j][i])
            RetValVer = FALSE;
        if (puzzle.solve[j][i] == ' ')
            SpaceVer = TRUE;
        j++;
    }
    if (SpaceHor)
        RetValHor = TRUE;
    if (SpaceVer)
        RetValVer = TRUE;
    if (!RetValHor || !RetValVer)
        RetVal = FALSE;
    return RetVal;
}

