/***************************************************************************
                          editorwidget.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editorwidget.h"

const editor_begin_y = 15;
const widget_width = 340;
const widget_height = 320;
const editor_bottom = 300;
const line_width = 200;
const line_height = 30;
const group_width = widget_width - 20;
const group_height = widget_height - 130;
const editor_width = int((group_width-30) /2);
const line_begin_x = 100;

//constructor
EditorWidget::EditorWidget(QWidget * parent, const char * name) :QWidget(parent,name)
{
    // defaults
    this -> resize(widget_width,widget_height);
    this -> setMinimumWidth(widget_width);
    this -> setMinimumHeight(widget_height);

    group_names = new QGroupBox("Names",this);
    group_names -> setGeometry(10,10,320,125);

    line_title = new QLineEdit(group_names);
    line_title -> setGeometry (100,20,210,25);

    line_author = new QLineEdit(group_names);
    line_author -> setGeometry (100,55,210,25);

    line_copyright = new QLineEdit(group_names);
    line_copyright -> setGeometry(100,90,210,25);

    title = new QLabel("Title:",group_names);
    title -> setGeometry(15,20,80,25);

    author = new QLabel("Author:",group_names);
    author -> setGeometry (15,55,80,25);

    copyright = new QLabel("Copyright:",group_names);
    copyright -> setGeometry(15,90,80,25);

    group_questions = new QGroupBox("Questions",this);

    across = new QLabel("Across",group_questions);
    across -> setGeometry (10,20,80,25);

    down = new QLabel("Down",group_questions);

    editor_across = new QMultiLineEdit(group_questions);

    editor_down = new QMultiLineEdit(group_questions);
//    editor_down -> setGeometry (int(group_width/2)+5 ,50,editor_width ,group_height - 60);
}

void EditorWidget::resizeEvent(QResizeEvent * r)
{
    QSize s = r -> size();
    int w = s.width();
    int w_e = int((w - 50) /2);
    int h = s.height();
    int h_e = h - 215;

    group_questions -> setGeometry(10,145,w - 20 , h - 155);

    editor_across -> setGeometry (10,50, w_e, h_e);
    editor_down -> setGeometry (int((w - 20)/2)+5 ,50,w_e ,h_e);

    down -> setGeometry(int((w-20)/2)+5,20,80,25);
}
