#ifndef KHTMLDLG_H
#define KHTMLDLG_H
#include <qdialog.h>
#include <html.h>

class QFile;

class KHTMLDlg:public QDialog
{
  Q_OBJECT
public:
  KHTMLDlg(QSize size, QWidget *parent=NULL, char *name=NULL);
  ~KHTMLDlg();
  void setVar(char *name, const char *val);
  void loadFile(char *filename);
  bool loaded(void);
signals:
  void action(const char *);
public slots:
  void docDone(void);
  void onUrlSlot(const char *);
  void urlSelected(const char *, int);
protected:
  int nextch(QFile *in);
  int getch(QFile *in, bool prepl=true);
  void addstr(const char *str, const char *param);
  bool readVar(QFile *, char *, char *);
  void keyPressEvent(QKeyEvent *e);
  void writeHTML(char *str, int size);
  void parseHTML();
  struct varitem
  {
    const char *str;
    char *param;
    int pos;
  } *current;
  char writebuf[1025];
  int bufpos;
  QStack<varitem> vstack;
  QDict<char> *dict;
  QList<QString> *list;
  KHTMLWidget *html;
  bool load;
};

#endif