#include <qkeycode.h>
#include <kmsgbox.h>
#include <kcursor.h>
#include <kapp.h>
#include <html.h>
#include "khtmldlg.h"
#include "krfile.h"

KHTMLDlg::KHTMLDlg(QSize size, QWidget *parent, char *name)
:QDialog(parent, name, true)
{
  html=new KHTMLWidget(this, NULL);
  dict=new QDict<char>(17, FALSE);
  list=new QList<QString>;
  list->setAutoDelete(true);
  resize(size);
  setCaption(i18n("Rogue"));
  html->setGeometry(0, 0, width(), height());
  setVar("OK", i18n("OK"));
  setVar("KDE_WALLPAPERDIR", KApplication::kde_wallpaperdir());
  connect(html, SIGNAL(formSubmitted(const char *, const char *, const char *)), 
    SLOT(accept()));
  connect(html, SIGNAL(URLSelected(const char *, int)),
    SLOT(urlSelected(const char *, int)));
  connect(html, SIGNAL(onURL(const char *)), SLOT(onUrlSlot(const char *)));
  connect(html, SIGNAL(documentDone()), SLOT(docDone()));
  bufpos=0;    
  load=0;
}

KHTMLDlg::~KHTMLDlg()
{
  if (dict) delete dict;
  if (list) delete list;
  if (html) delete html;
}

void KHTMLDlg::setVar(char *name, const char *val)
{
  dict->insert(name, val);
}

int KHTMLDlg::nextch(QFile *in)
{
  int c;
  while (current)
  {
    if ((c=current->str[current->pos++])!=0) return c;
    if (current->param) delete current->param;
    delete current;
    current=vstack.pop(); 
  }
  return in->getch();
}

void KHTMLDlg::addstr(const char *str, const char *param)
{
  varitem *newi=new varitem;
  newi->pos=0;
  newi->str=str;
  if (param && param[0])
  {
    newi->param=new char[strlen(param)+1];
    strcpy(newi->param, param);
  } else newi->param=NULL;
  vstack.push(current);
  current=newi; 
}

int KHTMLDlg::getch(QFile *in, bool prepl)
{
  int c;
  do
  {
    c=nextch(in);
    if (prepl && c=='%' && current && current->param)
      addstr(current->param, NULL);
      else break;
  } while (1);
  return c;
}

bool KHTMLDlg::readVar(QFile *in, char *varn, char *param)
{
  char *var, varval[1000];
  int c, l=1, st=0;
  *param=0;
  if ((c=getch(in))!='{')
  {
    varn[0]='$';
    return true;
  }
  var=varn;
  c=getch(in);
//  if (current)
//    printf("current: str=%s param=%s\n", current->str, current->param);
  while (c!=EOF)
  {
    if (c=='{') l++;
    if (c=='}')
      if ((--l)==0)
        break;
    if (c=='=' && st==0)
    {
      *var=0;  var=varval;
      st=1;
    } else if (c==':' && (st==0 || st==3))
      {
        if (st==3)
	{
	  char varn1[200], varn2[200], param2[1000], *vv;
	  *var=0;
	  readVar(in, varn1, param);
	  readVar(in, varn2, param2);
//	  printf("%s==%s ? var1: %s:%s, var2: %s:%s\n", varn, varval, 
//	    varn1, param, varn2, param);
	  if ((vv=(*dict)[varn])!=NULL && strcasecmp(vv, varval)==0)
	    strcpy(varn, varn1); else
	    {
	      strcpy(param, param2);
	      strcpy(varn, varn2);
	    }
	  st=4;
	} else
	{
          *var=0; var=param;
          st=2;
	}
      } else if (c=='?' && st==0)
        {
	  if ((c=getch(in))==EOF) return false;
	  if (c!='=') return false;
	  *var=0; var=varval;
	  st=3;
	} else if (st!=4) *(var++)=c;
    c=getch(in, st!=1);
  }
  if (st!=4) *var=0;
  if (st==1)
  {
    QString *str=new QString(varval);
    list->append(str);
    dict->insert(varn, *str);
//    printf("%s=%s\n", varn, varval);
    return false;
  }
  return true;
}

void KHTMLDlg::loadFile(char *filename)
{
  char varn[200], param[1000], *val;
  int c;
  QFile *in=openKrFile(QString("templates/")+filename, true);
  if (!in) return;
  current=NULL;
  html->begin();
  while ((c=getch(in))!=EOF)
  {
    if (c=='$')
    {
      if (!readVar(in, varn, param)) continue;
//      printf("var=%s param=%s\n", varn, param);
      if (varn[0]=='$')
      {
        writeHTML(varn, 1);
	continue;
      }
      if ((val=(*dict)[varn])!=NULL)
      {
        addstr(val, param);
      }
    } else writeHTML((char *)&c, 1);
  }
  list->clear();
  parseHTML();
  load=1;
  in->close();
}

void KHTMLDlg::docDone()
{
  if (html->docHeight()>html->height())
  {
    html->resize(html->width(), html->docHeight());
    resize(html->width(), html->height());
  }
}

void KHTMLDlg::onUrlSlot(const char *str)
{
  if (str==NULL) kapp->restoreOverrideCursor();
    else kapp->setOverrideCursor(KCursor::handCursor());
}

void KHTMLDlg::urlSelected(const char *url, int button)
{
  if (button==LeftButton)
  {
    if (memcmp(url, "action:", 7)==0)
    {
      kapp->restoreOverrideCursor();
      emit action(&url[7]);
    }
  }
}

bool KHTMLDlg::loaded()
{
  return load;
}

void KHTMLDlg::keyPressEvent(QKeyEvent *e)
{
  if (e->key()==Key_Enter || e->key()==Key_Return) accept();
    else QDialog::keyPressEvent(e);
}

void KHTMLDlg::writeHTML(char *str, int n)
{
  while (n+bufpos>=1024)
  {
    memcpy(writebuf+bufpos, str, 1024-bufpos);
    writebuf[1024]=0;
    html->write(writebuf);
    str+=(1024-bufpos);
    n-=(1024-bufpos);
    bufpos=0;
  }
  memcpy(writebuf+bufpos, str, n);
  bufpos+=n;
}

void KHTMLDlg::parseHTML()
{
  if (bufpos>0)
  {
    writebuf[bufpos]=0;
    html->write(writebuf);
  }
  html->end();
  html->parse();
}
