#include <qkeycode.h>
#include <kconfig.h>
#include <ctype.h>
#include <kapp.h>
#include "rogue/rogue.h"
#include "rogue/dun.h"
#include "kmsgbar.h"
#include "kinvwnd.h"
#include "roguec.h"
#include "kcmdr.h"

KCmdr *cmdr;

cmd r_cmdtable[]=
{
  {'h', 0, 0, NULL},
  {'l', 0, 0, NULL},
  {'k', 0, 0, NULL},
  {'j', 0, 0, NULL},
  {'u', 0, 0, NULL},
  {'y', 0, 0, NULL},
  {'b', 0, 0, NULL},
  {'n', 0, 0, NULL},
  {'H', 0, 0, NULL},
  {'L', 0, 0, NULL},
  {'K', 0, 0, NULL},
  {'J', 0, 0, NULL},
  {'U', 0, 0, NULL},
  {'Y', 0, 0, NULL},
  {'B', 0, 0, NULL},
  {'N', 0, 0, NULL},
  {'.', 0, 0, NULL},
  {'>', 0, 0, NULL},
  {'<', 0, 0, NULL},
  {',', 0, 0, NULL},
  {'m', ASK_DIR, 0, NULL},
  {'s', 0, 0, NULL},
  {'f', ASK_DIR, 0, NULL},
  {'e', ASK_ITEM, FOOD, _T("eat what")},
  {'r', ASK_ITEM, SCROLL, _T("read what")},
  {'P', ASK_ITEM|ASK_EMPTY_HAND, RING, _T("put on what")},
  {'^', ASK_DIR, 0, NULL},
  {'T', 0, 0, NULL},
  {'w', ASK_ITEM, ALL_OBJECTS&(~(ARMOR|RING)), _T("wield what")},
  {'z', ASK_DIR|ASK_ITEM, WAND, _T("zap what")},
  {'v', 0, 0, NULL},
  {'\x01', 0, 0, NULL},
  {'F', ASK_DIR, 0, NULL},
  {'q', ASK_ITEM, POTION, _T("quaff what")},
  {'d', ASK_ITEM, ALL_OBJECTS, _T("drop what")},
  {'R', ASK_HAND, 0, NULL},
  {'I', ASK_ITEM, ALL_OBJECTS, _T("inventory what")},
  {'W', ASK_ITEM, ARMOR, _T("wear what")},
  {'t', ASK_DIR|ASK_ITEM, ALL_OBJECTS, _T("throw what")},
  {')', 0, 0, NULL},
  {']', 0, 0, NULL},
  {'=', 0, 0, NULL},
  {CMD_CALL, ASK_ITEM, SCROLL|POTION|WAND|RING, _T("call what")},
  {CMD_WIZ, 0, 0, NULL},
  {CMD_QUIT, 0, 0, NULL},
  {CMD_INV, 0, 0, NULL},
  {CMD_HELP, 0, 0, NULL},
  {CMD_SAVE, 0, 0, NULL}
};

int ccmd, cmd_count;
int cmd_ask=0, cmd_mask;
const char *cmd_q;
int direction, item, hand;
object *item_o;

KCmdr::KCmdr()
:QObject(NULL, NULL)
{
  KConfig *cfg=kapp->getConfig();
  cmds=0;
  armor=1;
  lring=rring=0;
  stairs=1;
  running=0;
  ro=false;
  cfg->setGroup("Settings");
  running=cfg->readNumEntry("Run", 0);
}

KCmdr::~KCmdr()
{
}

#define CHECK(x1, x2, s1, s2)	if ((x1) && !(x2)) {(x1)=0; emit s1; } \
    if (!(x1) && (x2)) {(x1)=1; emit s2; }
void KCmdr::check(void)
{
  CHECK(armor, rogue.armor, noArmor(), wearsArmor())
  CHECK(lring, rogue.left_ring, noLRing(), putLRing(rogue.left_ring));
  CHECK(rring, rogue.right_ring, noRRing(), putRRing(rogue.right_ring));
  CHECK(stairs, dungeon[rogue.row][rogue.col]&STAIRS, onStairs(false), onStairs(true));
}
#undef CHECK

void KCmdr::restart()
{
  cmds=0;
  ccmd=cmd_ask=cmd_count=0;
  armor=1;
  lring=rring=0;
  stairs=1;
  check();
  if (running) emit isRunning(true);
}

void KCmdr::writeCfg(KConfig *cfg)
{
  cfg->writeEntry("Run", (int)running);
}

void KCmdr::saveProperties(KConfig *cfg)
{
  writeCfg(cfg);
  cfg->writeEntry("CmdrCmd", ccmd);
  cfg->writeEntry("CmdrAsk", cmd_ask);
  cfg->writeEntry("CmdrItem", item);
  cfg->writeEntry("CmdrMask", cmd_mask);
  cfg->writeEntry("CmdrAskQ", cmd_q);
  cfg->writeEntry("CmdrHand", hand);
  cfg->writeEntry("CmdrDir", direction);
  cfg->writeEntry("CmdrCmds", cmds);
  cfg->writeEntry("CmdrCmdCount", cmd_count);
}

void KCmdr::readProperties(KConfig *cfg)
{
  ccmd=cfg->readNumEntry("CmdrCmd");
  cmd_ask=cfg->readNumEntry("CmdrAsk");
  item=cfg->readNumEntry("CmdrItem");
  cmd_mask=cfg->readNumEntry("CmdrMask");
  cmd_q=cfg->readEntry("CmdrAskQ");
  hand=cfg->readNumEntry("CmdrHand");
  direction=cfg->readNumEntry("CmdrDir");
  cmds=cfg->readNumEntry("CmdrCmds");
  cmd_count=cfg->readNumEntry("CmdrCmdCount");
}

int KCmdr::getDirection(QKeyEvent *k)
{
  switch (k->ascii())
  {
    case '\x08':
    case 'h':
	return CMD_MOVE_LEFT;
    case '\x0c':
    case 'l':
	return CMD_MOVE_RIGHT;
    case '\x0a':
    case 'j':
	return CMD_MOVE_DOWN;
    case '\x0b':
    case 'k':
	return CMD_MOVE_UP;
    case '\x15':
    case 'u':
	return CMD_MOVE_UPRIGHT;
    case '\x0e':
    case 'n':
	return CMD_MOVE_DOWNRIGHT;
    case '\x19':
    case 'y':
	return CMD_MOVE_UPLEFT;
    case '\x02':
    case 'b':
	return CMD_MOVE_DOWNLEFT;
  }
  switch (k->key())
  {
    case Key_Left: return CMD_MOVE_LEFT;
    case Key_Right: return CMD_MOVE_RIGHT;
    case Key_Down: return CMD_MOVE_DOWN;
    case Key_Up: return CMD_MOVE_UP;
    case Key_Prior: return CMD_MOVE_UPRIGHT;
    case Key_Next: return CMD_MOVE_DOWNRIGHT;
    case Key_Home: return CMD_MOVE_UPLEFT;
    case Key_End: return CMD_MOVE_DOWNLEFT;
  }
  return 0;
}

#define CMD_LINV '\x09'
#define CMD_NITEM '\x03'

cmd wiz_cmdtable[] =
{
  {'\x0d', 0, 0, NULL},
  {'\x0f', 0, 0, NULL},
  {'\x13', 0, 0, NULL},
  {'\x14', 0, 0, NULL},
  {CMD_NITEM, 0, 0, NULL},
  {CMD_LINV, 0, 0, NULL}
};

#define NWIZCMD (sizeof(wiz_cmdtable)/sizeof(cmd))

void KCmdr::getCmd(QKeyEvent *k)
{  
  unsigned int i;
  if (k->ascii()>='0' && k->ascii()<='9' && cmd_count<100)
  {
    char str[MSGLEN];
    cmd_count*=10;
    cmd_count+=k->ascii()-'0';
    msg->invMsg();
    snprintf(str, MSGLEN, i18n("Repeat count: %d\n"), cmd_count);
    msg->message(str);
    return;
  }
  if ((ccmd=getDirection(k))==0)
  {
    for (i=0; i<NCMD; i++)
    {
      if (r_cmdtable[i].cmd==k->ascii())
      {
        ccmd=r_cmdtable[i].cmd;
	cmd_ask=r_cmdtable[i].ask;
	cmd_q=r_cmdtable[i].q;
	cmd_mask=r_cmdtable[i].mask;
	break;
      }
    }
    if (i==NCMD)
    {
      if (::wizard)
        for (i=0; i<NWIZCMD; i++)
	  if (wiz_cmdtable[i].cmd==k->ascii())
	  {
            ccmd=wiz_cmdtable[i].cmd;
	    cmd_ask=wiz_cmdtable[i].ask;
	    cmd_q=wiz_cmdtable[i].q;
	    cmd_mask=wiz_cmdtable[i].mask;
	    return;
	  }
      k->ignore();
      return;
    }
  } else if ((running && !(k->state()&ControlButton)) ||
             (!running && k->state()&ControlButton)) ccmd+=CMD_RUN;
}

void KCmdr::checkCmd()
{
  if (cmd_ask&ASK_ITEM)
    if (objfirst(cmd_mask)==NULL)
    {
      msg->message(i18n("nothing appropriate"));
      reset(0);
      return;
    }
  if (cmd_ask&ASK_EMPTY_HAND)
  {
    if (r_rings==2)
    {
      msg->message(i18n("wearing two rings already"));
      reset(0);
      return;
    }
    if (r_rings==1)
    {
      hand=(rogue.left_ring?'r':'l');
      cmd_ask&=~ASK_EMPTY_HAND;
    }
  }
  if (cmd_ask&ASK_HAND)
  {
    if (r_rings==0)
    {
      msg->message(i18n("not wearing any rings"));
      reset(0);
      return;
    }
    if (r_rings==1)
    {
      hand=(rogue.left_ring?'l':'r');
      cmd_ask&=~ASK_HAND;
    }
  }
}

void KCmdr::execCmd()
{
  int cmd=ccmd, count=cmd_count;
  ccmd=cmd_count=0;
  if (msg->willQuit) return;
  emit inCommand(true);
  switch (cmd)
  {
    case CMD_INV:
      showinv();
      break;
    case CMD_LINV:
      showlinv();
      break;
    case CMD_NITEM:
      nitem();
      break;
    case CMD_NEW_LEVEL:
      free_stuff(&level_objects);
      free_stuff(&level_monsters);
      emit newlevel();
      break;
    case CMD_QUIT:
      emit quit();
      break;
    case CMD_CALL:
      call(item);
      break;
    case CMD_WIZ:
      emit wizard();
      break;
    case CMD_HELP:
      emit help();
      break;
    default:
      play_level(cmd, count);
      break;
  }
  check();
  if (cmd_ask) newmsg(false, true);
  msg->removeMore();
  emit inCommand(false);
}

void KCmdr::cmdLoop(void)
{
  if (ccmd==0 || cmd_ask!=0) return;
  while (cmd_ask==0 && ccmd!=0)
    execCmd();
  if (cmd_ask!=0) disableCmds();
}

void KCmdr::newmsg(int enable, int more)
{
  if (!more) msg->invMsg();
  checkCmd();
  if (cmd_ask&ASK_DIR)
  {
    msg->message(i18n("direction?"));
    return;
  } 
  if (cmd_ask&ASK_ITEM)
  {
    char str[200];
    strcpy(str, kapp->getLocale()->translate(cmd_q));
    strcat(str, _i18n(" (press '?' for list)?"));
    msg->message(str);
    return;
  }
  if (cmd_ask&(ASK_HAND|ASK_EMPTY_HAND))
  {
    msg->message(i18n("left or right hand?"));
    return;
  }
  if (cmd_ask==ASK_TRY_AGAIN) cmd_ask=0;
  if (enable && !cmd_ask) enableCmds();
}

void KCmdr::interpretKey(QKeyEvent *k)
{
//  printf("interpretKey(%c), cmds=%d ccmd=%d  cmd_ask=%d\n", k->ascii(), cmds, 
//    ccmd, cmd_ask);
  if (k->key()==Key_Escape)
  {
    if (cmd_ask) reset(1);
      else if (cmd_count!=0)
      {
        msg->invMsg();
        cmd_count=0;
      }
    return;
  }
  if (cmd_ask==0 && ccmd==0 && cmds==0)
  {
    getCmd(k);
    if (ccmd!=0)
    {
      newmsg(0);
      if (cmd_ask!=0) disableCmds();
    }  
  } else if (cmd_ask&ASK_DIR)
  {
    int dir=getDirection(k);
    if (dir!=0)
    {
      direction=dir;
      cmd_ask&=~ASK_DIR;
      newmsg(1);
    } else k->ignore();
  } else if (cmd_ask&ASK_ITEM)
  {
    char c=tolower(k->ascii());
    if (c==0) return;
    if (c=='?')
    {
      int res;
      KInvWnd dlg(kapp->mainWidget(), NULL, cmd_mask, true);
      dlg.exec();
      if ((res=dlg.result())==QDialog::Rejected && !(cmd_ask&ASK_TRY_AGAIN))
      {
	reset(1);
	return;
      }
      c=res;
    }
    if (c<='z' && c>='a' && (item_o=get_letter_object(c))!=NULL)
    {
      item=c;
      if ((item_o->what_is&cmd_mask)==0)
      {
        reset(1);
	if (cmd_mask&WEAPON) msg->message(i18n("you can't wield that"));
	  else if (cmd_mask&FOOD) msg->message(i18n("you can't eat that"));
	  else if (cmd_mask&ARMOR) msg->message(i18n("you can't wear that"));
	  else if (cmd_mask&SCROLL) msg->message(i18n("you can't read that"));
	  else if (cmd_mask&POTION) msg->message(i18n("you can't drink that"));
	  else if (cmd_mask&WAND) msg->message(i18n("you can't zap with that"));
	  else if (cmd_mask&RING) msg->message(i18n("that's not a ring"));
	  else msg->message(i18n("invalid item"));
      } else
      {
        cmd_ask&=~ASK_ITEM;
	newmsg(1);
      }
    } else
    {
      if (cmd_ask&ASK_TRY_AGAIN)
      {
	msg->invMsg();
        msg->message(i18n("no such item, try again."));
	newmsg(0, 1);
	msg->removeMore();
	return;
      }
      reset(1);
      msg->message(i18n("no such item."));
    }
  } else if (cmd_ask&(ASK_HAND|ASK_EMPTY_HAND))
  {
    char c=tolower(k->ascii());
    if (c!='l' && c!='r')
    {
      k->ignore();
      return;
    }
    hand=c;
    cmd_ask&=~(ASK_HAND|ASK_EMPTY_HAND);
    newmsg(1);
  } else if (cmd_ask!=0)
  {
//    printf("unknown question (%04x), ccmd=%04x\n", cmd_ask, ccmd);
    cmd_ask=0;
    newmsg(1);
  }
  cmdLoop();
}

void KCmdr::setReadOnly(bool b)
{
  if (ro==b) return;
  if (b)
  {
    ro=b;
    disableCmds();
  } else
  {
    ro=b;
    emit enableButtons(true); //cmds=0 is done by cmdr->reset();
  }
}

void KCmdr::disableCmds()
{
  if (cmds++==0) emit enableButtons(false);
}

void KCmdr::enableCmds()
{
  if (--cmds==0) emit enableButtons(true);
}

void KCmdr::command(int _cmd, int _item, int _direction, int _hand)
{
  msg->invMsg();
  ccmd=_cmd;
  direction=_direction;
  item=_item;
  hand=_hand;
  cmd_ask=0;  
  if (item!=0) item_o=get_letter_object(item);
  if (item==0 || item_o!=NULL) cmdLoop();
}

#define CMD(fn, x) void KCmdr::fn { command##x; }
#define CMD2(fn, c, ask) void KCmdr::fn {ccmd=c; cmd_ask=ask; disableCmds(); newmsg(1);}
#define CMDASK(fn, mask, c) void KCmdr::fn { KInvWnd dlg(kapp->mainWidget(), NULL, mask, true);\
     dlg.exec(); \
     if (dlg.result()!=QDialog::Rejected) command(c, dlg.result()); }
#define CMDASK2(fn, mask, c, ask) void KCmdr::fn {KInvWnd dlg(kapp->mainWidget(), NULL, mask, true);\
     dlg.exec(); 					\
     if (dlg.result()==QDialog::Rejected) return; 	\
     item=dlg.result(); 				\
     item_o=get_letter_object(item);			\
     if (item_o==NULL) return; 				\
     cmd_ask=ask;					\
     ccmd=c;						\
     disableCmds();					\
     newmsg(1);						\
}

CMD(eat(int i), ('e', i))
CMD(read(int i), ('r', i))
CMD(wield(int i), ('w', i))
CMD(drop(int i), ('d', i))
CMD(quaff(int i), ('q', i))
CMD(wear(int i), ('W', i))
CMD(takeoff(), ('T'))
CMD(downstair(), ('>'))
CMD(upstair(), ('<'))
CMD(putonl(int i), ('P', i, 0, 'l'))
CMD(putonr(int i), ('P', i, 0, 'r'))
CMD(lremr(), ('R', 0, 0, 'l'))
CMD(rremr(), ('R', 0, 0, 'r'))
CMD(restbt(), ('.'))
CMD(searchbt(), ('s'))
CMD2(idtrap(), '^', ASK_DIR)
CMD2(remove(), 'R', ASK_HAND)
CMDASK(eat(), FOOD, 'e')
CMDASK(read(), SCROLL, 'r')
CMDASK(quaff(), POTION, 'q')
CMDASK(wield(), ALL_OBJECTS&(~(ARMOR|RING)), 'w')
CMDASK(wear(), ARMOR, 'W')
CMDASK(drop(), ALL_OBJECTS, 'd')
CMDASK(call(), RING|SCROLL|WAND|POTION, 'c')
CMDASK2(puton(), RING, 'P', ASK_HAND)
CMDASK2(throwsl(), ALL_OBJECTS, 't', ASK_DIR)
CMDASK2(zap(), WAND, 'z', ASK_DIR)

#undef CMD
#undef CMD2
#undef CMDASK
#undef CMDASK2

void KCmdr::throwsl(int i)
{
  item_o=get_letter_object(i);
  if (item_o==NULL) return;
  ccmd='t';
  cmd_ask=ASK_DIR;
  item=i;
  newmsg(0);
  disableCmds();
}

void KCmdr::puton(int i)
{
  item_o=get_letter_object(i);
  if (item_o==NULL) return;
  ccmd='P';
  cmd_ask=ASK_EMPTY_HAND;
  item=i;
  disableCmds();
  newmsg(1);
}

void KCmdr::zap(int i)
{
  item_o=get_letter_object(i);
  if (item_o==NULL) return;
  ccmd='z';
  cmd_ask=ASK_DIR;
  item=i;
  newmsg(0);
  disableCmds();
}

void KCmdr::run(void)
{
  running=!running;
  emit isRunning(running);
}

void KCmdr::nitem()
{
  if (pack_count(NULL)>=MAX_PACK_COUNT)
  {
    msg->message(i18n("pack too full"));
    return;
  }
  KNItemDlg dlg(kapp->mainWidget());
  dlg.exec();
}

void KCmdr::showinv()
{
  KInvWnd wnd(kapp->mainWidget(), "Dialog");
  wnd.exec();
}

extern object level_objects;

void KCmdr::showlinv()
{
  KInvWnd wnd(kapp->mainWidget(), "Dialog", ALL_OBJECTS, true, &level_objects);
  wnd.exec();
}

void KCmdr::call(int i)
{
  const char *c;
  KStrDlg strdlg(i18n("&New name:"), false, kapp->mainWidget());
  strdlg.exec();
  c=strdlg.text();
  if (strdlg.result()!=QDialog::Rejected && c!=NULL && c[0])
  {
    msg->invMsg();
    if (strlen(c)>=64) msg->message(i18n("name too long")); 
      else call_it(i, c);
  }
}

