#ifndef _KPUISSANCE4_H_
#define _KPUISSANCE4_H_

#include <ktmainwindow.h>
#include <qlabel.h>

#include "board.h"

enum PlayerType { Computer, Human};
enum LevelType { Easy, Medium, Hard};

struct BoardOptionsStruct
{
	int	NumCols, NumRows, NumPuis;
	int	Player1, Player2;
	int	Level;
	bool	UseBackgroundPixmap;
	QString	BackgroundPixmap;
	QColor	BackgroundColor;
};

class KPuissance4 : public KTMainWindow
{
	Q_OBJECT;

public:
	KPuissance4(QWidget *parent = 0, const char *name = 0);
	~KPuissance4();

protected:
	void initToolBar();
	void initMenuBar();
	void initStatusBar();
	void initBoard();

	bool queryClose();
	void readConfig(KConfig *);
	void saveConfig(KConfig *);

protected slots:
	void newGame();
	void openGame();
	void saveGame();
	void quitGame();
	void configure();
	void undo();
	void hint();
	void showHelp();
	void slotMessage(const char *text);

protected:
	BoardWidget	*Board;
	BoardOptionsStruct	BoardOptions;
};

#endif
