#ifndef _CASEWIDGET_H_
#define _CASEWIDGET_H_

#include <qtableview.h>
#include <qpixmap.h>

enum StateType { Empty, Player1, Player2};

class CaseWidget : public QTableView
{
public:
	CaseWidget(int ncol, int nrow, QWidget *parent = 0, const char *name = 0);

	void setPixmaps(QPixmap *pix1, QPixmap *pix2) { Pix[0] = pix1; Pix[1] = pix2;}
	void setState(int row, int col, int state);
	int state(int row, int col) { return StateTable[row][col];}
	void restart() { initStateTable(); update();}

protected:
	QPixmap		*Pix[2];
	int		StateTable[20][20];

protected:
	void initStateTable();
	void resizeEvent(QResizeEvent *e);
	void paintCell(QPainter *p, int row, int col);
};

#endif
