#ifndef _SERVER_H_
#define _SERVER_H_

#include <qmultilinedit.h>
#include <ksock.h>
#include <qlist.h>
#include <qstring.h>
#include <qstrlist.h>
#include "intpuis.h"

class Server : public QMultiLineEdit
{
	Q_OBJECT;

public:
	Server(int port, int nc = 7, int nr = 6, int np = 4, QWidget *parent = 0, const char *name = 0);
	Server(const char *path, int nc = 7, int nr = 6, int np = 4, QWidget *parent = 0, const char *name = 0);
	~Server();

	void broadcastMessage(const char *msg, bool deferred = true);
	void sendMessage(KSocket *sock, const char *msg, bool deferred = true);
	void dispatch(KSocket *sock, QStrList& cmd);
	void message(const char *msg);

protected:
	KServerSocket	*ServerSocket;
	QList<KSocket>	SocketList;
	QString		MessageToSend;
	InternalPuissance	*Table;
	int		CurrentPlayer;
	bool		LocalMode;

protected slots:
	void newConnection(KSocket *sock);
	void slotReadEvent(KSocket *sock);
	void slotWriteEvent(KSocket *sock);

protected:
	void closeEvent(QCloseEvent *e);
	void initServer(int nc, int nr, int np);

	void socketClosed(KSocket *sock);
	void socketRestart(KSocket *sock);
	void socketPlay(KSocket *sock, int player, int col);
	void socketMessage(KSocket *sock, const char *msg);
	void socketDimensions(KSocket *sock, int nc, int nr, int np);
	void socketUndo(KSocket *sock, int n);
};

#endif
