#ifndef PAINTER_H
#define PAINTER_H

#include <qpixmap.h>
#include <qbitmap.h>
#include <qcolor.h>
#include <qlist.h>
#include <qregexp.h>

#include "board.h"
#include "bitfont.h"
#include "colors.h"

enum PixMap { PacmanPix, DyingPix, MonsterPix, EyesPix, FruitPix,
	      PointPix, SwitchPix, WallPix, PrisonPix };
enum DrawWidget { Widget, RoomPix, BackPix };

class Painter
{
public:
    Painter (Board *, QWidget *parent=0, Bitfont *font=0, QString pixDir=0);
    QPixmap levelPix() { return roomPix; }

    void setFont(Bitfont *font=0);
    void setPixmaps(QString pixDir=0);

    void initPixmaps(QString pixDir);
    void initRoomPixmap();
    void initbackPixmaps();

    QRect rect(int pos, PixMap pix);
    QRect rect(int pos, QString str, int align = AlignCenter );
    QRect rect(QRect r1, QRect r2);

    void draw(QPoint point, DrawWidget where, QPixmap pix);
    void draw(QRect rect, DrawWidget where, QPixmap pix);
    void draw(int pos, DrawWidget where, PixMap pix, int i = 0);
    QPixmap draw(int pos, DrawWidget where, QString str, QColor fg, QColor bg = QColor(),
                 int align = AlignCenter);
    QRect draw(int col, int row, DrawWidget where, QString str,
	       QColor fg, QColor bg = QColor(), int align = AlignCenter);

    void drawBrick(int pos);
    void drawPrison(int pos);
    void drawPoint(int pos);
    void drawSwitch(int pos);

    void erase(int pos, PixMap pix);

    int maxPixmaps(PixMap pix);

private:
    QWidget *w;
    Board *board;
    Bitfont *bitfont;

    int BlockWidth;
    int BlockHeight;

    QList<QPixmap> *loadPixmap(QWidget *parent, QString pixmapName, QList<QPixmap> *pixmaps=0);

    QPoint point(int pos);

    QList<QPixmap> *wallPix;
    QList<QPixmap> *prisonPix;
    QList<QPixmap> *pointPix;
    QList<QPixmap> *switchPix;
    QList<QPixmap> *fruitPix;
    QList<QPixmap> *pacmanPix;
    QList<QPixmap> *dyingPix;
    QList<QPixmap> *eyesPix;
    QList<QPixmap> *monsterPix;

    QPixmap roomPix;
    QPixmap backPix;

    bool plainColor;
    QColor backgroundColor;
};

#endif // PAINTER_H

