/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _MAINWIDGET_H
#define _MAINWIDGET_H

#include <ktopwidget.h>
#include <ktoolbar.h>
#include "kmamerun.h"
#include "preferences.h"
#include <drag.h>

#define ID_FILE_RUN	1
#define ID_FILE_QUIT	2

#define ID_SH_ALL		10
#define ID_SH_AVAILABLE		11
#define ID_SH_NOTAVAILABLE	12

#define ID_SO_NAME	20
#define ID_SO_NAMEFULL	21
#define ID_SO_TYPE	22
#define ID_SO_PRIORITY	23

#define ID_OP_PREF	50
#define ID_OP_TOOLBAR	51
#define ID_OP_LOGFILE	52
#define ID_OP_SAVE	55

#define ID_HELP_HELP	90
#define ID_HELP_ABOUT	91

class KPanner;
class QToolTipGroup;

class MainWidget : public KTopLevelWidget {
    Q_OBJECT
    
public:

    MainWidget(char *fname=0, QWidget *parent=0,const char *name=0 );
    ~MainWidget();
    
public slots:
    void menuCallback(int);

private:
    KToolBar *toolbar;
    KMenuBar *menu;
    KMameRun *kmamerun_widget;
    KConfig  *kconfig;
    int
        sortOrder,
        showFlag;
    bool
        showToolbar;
    Preferences *prefdiag;
    QPopupMenu
        *moptions, *mshow, *msort;
    QString
        mamecmd;

protected slots:
    void preferencesHide();
    void updateConfig();
    void updateListbox();
    void setGamePref(const char *item, int pos);

protected:
    void bindKeys();
    int initMenu();
    void saveOptions();
};

#endif
