/*
 *   kmamerun - a interface for M.A.M.E
 *   Copyright (C) 1998  Juergen Vigna
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef KMameRun_included
#define KMameRun_included

#include <qfiledlg.h>
#include <kprocess.h>
#include "kmamerundata.h"
#include "loglistbox.h"
#include "qmylist.h"

class KMameRun : public KMameRunData
{
    Q_OBJECT

public:

    enum {
        OPEN_READWRITE 	= 1, 
        OPEN_READONLY 	= 2, 
        OPEN_INSERT	= 4
    };
    bool
        showLogfile;

    KMameRun(QWidget* parent = NULL,const char* name = NULL,
             unsigned int sf=0, int so=1);
    virtual ~KMameRun();
    int RunGame(const char *item=0);
    int SetFileName(const char* fname);
    int totMinimumHeight();
    void toggleLogfile();
    void reloadListbox();
    int reloadListbox(unsigned int mode,bool force=false);
    void setSortMode(int mode);

private:
    QString
        gameName,
        current_directory;
    LogListBox
        *error_listbox;
    unsigned int
        showFlag,
        gameNameLen,
        gameNameFullLen;
    QMyList
        *qml;

    QFileDialog* getFileDialog(const char* captiontext);
    int SetFileName();

protected slots:
    void RunGameCB();
    void ReadStderr(KProcess *, char *buffer, int buflen);
    void ReadStdout(KProcess *, char *buffer, int buflen);
    void RunGameDone(KProcess*);
    void gameSelectCB(const char *item);
    void gameHighlightCB(const char *item);

protected:
    virtual void resizeEvent (QResizeEvent *rse);    
    void setPos(QLabel *lab, QLineEdit *le);
    int getGameType(const char *cname);
    int getGamePriority(const char *cname);
    void loadListbox();

signals:
    void gameSelected(const char *item, int pos);
};
#endif // KMameRun_included
