#include <Fliessband.h>
#include <Fliessband.moc>

FliessbandStein::FliessbandStein( QWidget *parent, int Farbe ): QWidget(parent)
{
	merkFarbe = Farbe;
	animState = 0;
}

void FliessbandStein::showAnimation()
{
	timer = new CpTimerObj(80);
	connect( timer, SIGNAL(timerCalled()), SLOT(animate()) );
}

void FliessbandStein::paintEvent( QPaintEvent *PE )
{

	QPainter p;
                p.begin(this);
		 switch(Farbe())
		{
			case hell_blau:
				p.setPen(QColor(0,0,190));
				p.setBrush(QColor(70,150,255));
			break;
			
			case hell_gruen:
				p.setPen(QColor(0,140,0));
				p.setBrush(QColor(50,240,50));
			break;

			case orange:
				p.setPen(QColor(150,70,0));
				p.setBrush(QColor(255,150,40));
			break;
			
			case pink:
				p.setPen(QColor(150,70,0));
				p.setBrush(QColor(255,100,250));
			break;

			case dunkel_blau:
				p.setPen(QColor(0,0,50));
				p.setBrush(QColor(0,0,150));
			break;

			case oliv_gruen:
				p.setPen(QColor(0,40,0));
				p.setBrush(QColor(0,80,0));
			break;

			case rosa:
				p.setPen(QColor(200,100,100));
				p.setBrush(QColor(255,180,180));
			break;

			case dunkel_rot:
				p.setPen(QColor(100,0,0));
				p.setBrush(QColor(199,0,0));
			break;

			case rot_braun:
				p.setPen(QColor(10,0,0));
				p.setBrush(QColor(110,0,0));
			break;

			case weiss:
				p.setPen(QColor(200,200,200));
				p.setBrush(QColor(235,235,235));
			break;
	}



	p.drawRect( 0, 0, width(), height() );

	p.end();
}

void FliessbandStein::animate() //slot
{
	if ( animState == 3 )
	{
		animState = 0;
		delete timer;
		return;
	}

	setGeometry( x(), y() -(width()/3), width(),(animState+1)*(width()/3) );

	if (animState == 1) show();

	animState++;
}

/****************************************FliessbandStein End*****************************************/
/**********************************************New Class*********************************************/
/*************************************FiesbandC Begin ***********************************************/

FliessbandC::FliessbandC (QWidget *parent, int level ): QWidget(parent)
{
	int i, ii;

	for ( i = 0; i < 11; i++ )
		for( ii = 0; ii < 6; ii++ )
		{
			lpts[i][ii][0] = -1;
			lpts[i][ii][1] = 0;
		}

	moveTimer = new CpTimerObj(400);

	connect( moveTimer, SIGNAL(timerCalled()), SLOT(moveSlot()) );

	steinIndex = 0;

	for ( i = 0; i < 20; i++ )
	{
		steinPos[i][0] = 0;
		steinPos[i][1] = 0;
	}

	newCounter = 0;
	myLevel = level;
	Pause=false;
}

void FliessbandC::clear()
{
	
}

void FliessbandC::paintEvent(QPaintEvent *PE)
{
	int i;

	QPainter P;
	P.begin(this);

	for( i = 0; i < 6; i++ )
	{
		P.drawLine( lpts[0][i][0], lpts[0][i][1], lpts[10][i][0], lpts[10][i][1] );
	}

	for( i = 0; i < 11; i++ )
	{
		P.drawLine( lpts[i][0][0], lpts[i][0][1], lpts[i][5][0], lpts[i][5][1] );
	}

	P.end();
}


void FliessbandC::resizeEvent(QResizeEvent *RE)
{
const int uR = 30;
const int h = height();
const int w = width();

int i, ii;
int br;

	for( i = 0; i < 11; i++ )
	{
		br = (w/5)- i*(uR/10);

		for( ii = 2; ii >= 0; ii-- )
		{
			lpts[i][ii][0] = (w/2) - ((2-ii)*br) -(br/2);
			lpts[i][ii][1] = (10-i)*(h/10); //y-pos
		}

		for( ii = 3; ii < 6; ii++ )
		{
			lpts[i][ii][0] = (w/2) +((ii-3)*br) +(br/2);
			lpts[i][ii][1] = (10-i)*(h/10); //y-pos
		}
	}
}

void FliessbandC::moveSlot() //slot
{
int i;
int steinX, steinY, steinB;
int neueFarbe;

	if (Pause) return;

	for ( i = 0; i < steinIndex; i++ )
	{
		if( steinPos[i][0] != -1 )
		{
			steinPos[i][0]++;

			if ( steinPos[i][0] >= 11 )
			{
				emit( wirf( stein[i]->Farbe(), steinPos[i][1] ) );
				debug( "SIGNAL emitted" );
				delete stein[i];
				steinPos[i][0] = -1;
				steinPos[i][1] = 0;

			}
			else
			{
				stein[i]->hide();

				steinX = lpts [10-steinPos[i][0]] [steinPos[i][1]] [0];
				steinY = lpts [10-steinPos[i][0]] [steinPos[i][1]] [1];

				steinB = -lpts [10-steinPos[i][0]] [steinPos[i][1]] [0]
					+ lpts [10-steinPos[i][0]] [steinPos[i][1]+1] [0];

				stein[i]->setGeometry(steinX, steinY, steinB, -1*steinB);

				stein[i]->showAnimation();
			}

		}

	}


	if( newCounter == 0 )
	{
		switch ( myLevel )
		{
			case 1:
				neueFarbe = CpRandom(11);
				break;

			default:
				fatal ( "Unknown level \"%d\". Sorry.", myLevel );
		}


		stein[steinIndex] = new FliessbandStein( this, neueFarbe );

		steinPos[steinIndex][0] = 0; //Pos
		steinPos[steinIndex][1] = CpRandom(5); //Bahn

		steinIndex++;
		if (steinIndex == 30) steinIndex = 0;
	}

	newCounter++;
	if( newCounter >= 11 ) newCounter = 0;

} //moveSlot()
