/* zone_board.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "includes.h"

#include "go.h"
#include "zone_board.moc"
#include "go_board.h"

KZoneBoard::KZoneBoard( KGoBoard *b, QObject *parent )
	: QObject( parent, 0 ), board(b)
{
	xWidth = board->getXWidth() ;
	yWidth = board->getYWidth() ;

	KGoBoard::createArray( zones, xWidth, yWidth ) ;
	KGoBoard::createArray( region, xWidth, yWidth ) ;

	for(int i=0;i<xWidth;i++)
	for(int j=0;j<yWidth;j++)
		zones[i][j]=board->get(i,j) ;
	debug("new zone");

}

KZoneBoard::~KZoneBoard()
{
	debug("del zone");
	xWidth = board->getXWidth() ;
	yWidth = board->getYWidth() ;

	KGoBoard::deleteArray( zones, xWidth, yWidth ) ;
	KGoBoard::deleteArray( region, xWidth, yWidth ) ;
}

int KZoneBoard::get(int i, int j )
{
	if ( inRange( i, j ) )
		return zones[i][j] ;
	else	return EMPTY ; 
}

void KZoneBoard::set(int i, int j, int p, bool redraw )
{
	if ( inRange( i, j ) )
	{
		zones[i][j]=p ;
		board->set(i, j, p, redraw ) ; 
	}
}

void KZoneBoard::remove( int x, int y, bool redraw )
{
	if ( inRange( x, y ) )
	{
		if ( get(x,y)==WHITE )
			board->white_cap++ ;
		if ( get(x,y)==BLACK )
			board->black_cap++ ;
		set( x, y, EMPTY, redraw ) ; 
	}
}  

void KZoneBoard::determineZones()
{
	findZones() ;

	for(int i=0;i<xWidth;i++)
	for(int j=0;j<yWidth;j++)
		board->set(i,j, get(i,j), false ) ;
	board->emit_boardStateChange( BOARD_SET ) ;
}

void KZoneBoard::removeDead(int x, int y )
{
	if ( ! inRange(x,y) )
		return ;

	if ( get(x,y)==WHITE )
	{
		removeDeadNeighbours( x, y, WHITE ) ;
	}
	else if ( get(x,y)==BLACK )
	{
		removeDeadNeighbours( x, y, BLACK ) ;
	}
	board->emit_boardStateChange( BOARD_SET ) ;
}

void KZoneBoard::removeDeadNeighbours(int x, int y, int player )
{
	if ( ! inRange(x,y) )
		return ;

	if ( get(x, y)==player)
	{
		remove( x, y, false ) ;

		removeDeadNeighbours( x, y-1, player ) ;
		removeDeadNeighbours( x, y+1, player ) ;
		removeDeadNeighbours( x-1, y, player ) ;
		removeDeadNeighbours( x+1, y, player ) ;
	}
}

unsigned char** KZoneBoard::getResult()
{
	return (unsigned char**)zones ;
}

bool KZoneBoard::inRange( int x, int y )
{
	return ( x>-1 && x<xWidth && y>-1 && y<yWidth ) ;
}

void KZoneBoard::findZones()
{
	// debug("findZones()");
	int i, j ;

	for(i=0;i<xWidth;i++)
	for(j=0;j<yWidth;j++)
	{
		if( findRegion( i, j ) )
			fillRegion() ;
	}
}

bool KZoneBoard::findRegion( int x, int y )
{
	int i, j ;

	for(i=0;i<xWidth;i++)
	for(j=0;j<yWidth;j++)
		region[i][j]=EMPTY ;

	if ( zones[x][y]!=EMPTY )
		return false ;

	addRegionElements( x, y ) ;
	return true ;
}

void KZoneBoard::addRegionElements( int x, int y )
{
	region[x][y]=1 ;

	if ( zones[x][y]!=EMPTY )
		return ;

	int i, j ;
	/* we check all four sides */

	if ( x>0 )
	{
		i=x-1; j=y;
		tryAddElement( i, j ) ;
	}
	if ( x<xWidth-1 )
	{
		i=x+1; j=y;
		tryAddElement( i, j ) ;
	}
	if ( y>0 )
	{
		i=x; j=y-1;
		tryAddElement( i, j ) ;
	}
	if ( y<yWidth-1 )
	{
		i=x; j=y+1;
		tryAddElement( i, j ) ;
	}
}

void KZoneBoard::tryAddElement(int x, int y )
{
		if ( region[x][y]==0 )
		{
			// not added yet...
			addRegionElements(x, y) ;
		}
}
 
void KZoneBoard::fillRegion()
{
	int i, j ;
/*
	debug("region layout") ;
	for(i=0;i<xWidth;i++)
	for(j=0;j<yWidth;j++)
	{
		printf("%d ", region[i][j]);
		if(j==xWidth-1) printf("\n") ;
	}
*/
	int color = EMPTY ;

	for(i=0;i<xWidth;i++)
	for(j=0;j<yWidth;j++)
	{
		if( region[i][j]==1 )
		{
			switch( zones[i][j] )
			{
				case EMPTY:	break;
				case WHITE:
				case BLACK:	
				{
					if( color==EMPTY )
					{
						color=zones[i][j] ;
						break ;
					}
					else if( color==zones[i][j] )
						break ;
					else
					{
						color=NEUTRAL ;
						break ;
					}
				}
				case WHITE_ZONE:
				case BLACK_ZONE:
				case NEUTRAL:
				default:	printf(
			"error: zones[%d][%d]==%d\n", i, j, zones[i][j] );
						break ;
			}
		}
		if( color==NEUTRAL ) break ;
	}

//	printf("filling region with color %d\n", color ) ;

	for(i=0;i<xWidth;i++)
	for(j=0;j<yWidth;j++)
	{
		if( region[i][j]==1 && zones[i][j]==EMPTY )
		{
			if( color==WHITE )
				zones[i][j]=WHITE_ZONE ;
			else if ( color==BLACK )
				zones[i][j]=BLACK_ZONE ;
			else	zones[i][j]=color ;
	 	}
	}
}


