/* ktimer.cpp
 *
 * Pieter Eendeak <pte@ddsw.nl>
 */

#include "ktimer.h"
#include <qdatetm.h>

/**
 * KTimer is a simple to use timer
 */
KTimer::KTimer()
	: state( STOPPED )
{
	t = new QTime() ;
	t->start() ;
}

KTimer::~KTimer()
{
	delete t ;
}

void KTimer::start()
{
	t->start() ;
	zero() ;
	resume() ;
}

void KTimer::stop()
{
	freeze() ;
	zero() ;
}

void KTimer::freeze() 
{
	if ( state == RUNNING )
	{
		total += t->elapsed() ;
		state = STOPPED ;
	}
}

void KTimer::resume() 
{
	if ( state == STOPPED )
	{
		t->start() ;
		state = RUNNING ;	
	}
}

void KTimer::zero()
{
	total = 0 ;
}

int KTimer::getSeconds()
{
	return (int)(getTime()/1000) ;
} ;

long KTimer::getTime()
{
	long ret = total ;
	if ( state==RUNNING )
		ret += t->elapsed() ;
	return ret ;
}

void KTimer::setTime( long msecs)
{
	zero() ;
	total = msecs ;
}

bool KTimer::isRunning()
{
	return ( state == RUNNING ) ;
}
