/* go_player.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <stdio.h>
#include <qobject.h>
#include <qwidget.h>
#include <qsignal.h>
#include "go.h"
#include "go_board.h"
#include "go_player.moc"

KGoPlayer::KGoPlayer( int c, KGoBoard *b,
		QWidget *parent, const char *name )
 	: QObject( parent, name )
{
	setBoard( b ) ;
	color = c ;

	#ifdef DEBUG 
	count++;
	printf("Number of players: %d\n", count ) ;
	#endif
}

KGoPlayer::~KGoPlayer()
{
	#ifdef DEBUG 
	count--;
	#endif
}

int KGoPlayer::load( QDataStream &, KGoBoard * )
{
	return ERROR ;
}

int KGoPlayer::save( QDataStream & )
{
	return ERROR ;
}

bool KGoPlayer::canBeSaved()
{
	return false ;
}

KGoBoard* KGoPlayer::getBoard()
{
	return board ;
}

void KGoPlayer::setBoard( KGoBoard *b )
{
	board = b ;
}

void KGoPlayer::boardStateChange( int ) 
{
}

int KGoPlayer::getColor()
{
	return color ;
}

bool KGoPlayer::toMove()
{
	return ( playerToMove()==getColor() ) ;
}

int KGoPlayer::playerToMove()
{
	return board->playerToMove() ;
}

#ifdef DEBUG
int KGoPlayer::count=0;
#endif
