/* go_player.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <qobject.h>
#include <qwidget.h>
#include <qsignal.h>
#include "go_board.h"
#include "go_player.h"
#include "dummy_player.moc"

KDummyPlayer::KDummyPlayer( bool c, KGoBoard *b,
		QWidget *parent, const char *name )
	: KGoPlayer( c, b, parent, name )
{
}

KDummyPlayer::~KDummyPlayer()
{
}

void KDummyPlayer::opponentMoved( int x,int y )
{
	emit notifyOpponentMoved( x, y ) ;
}

void KDummyPlayer::illegalMove( int r, int p )
{
	emit notifyIllegalMove( r, p ) ;
}

void KDummyPlayer::playMove( int x, int y )
{
	emit doMove( x, y ) ;
} 

void KDummyPlayer::boardSetup()
{
	emit notifyBoardSetup() ;
}




