/*************************************************************************

  basicCard -- displayable cards with values

     Copyright (C) 1995  Paul Olav Tvete

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.

*************************************************************************/

#ifndef P_BASIC_CARD
#define P_BASIC_CARD


#include <qlabel.h>
#include "cardmaps.h"
/** This class defines the basic card */
class basicCard : public QLabel { 
  Q_OBJECT
public:
/** the name of the suits */
 enum Suits  { None=0, Clubs=1, Diamonds=2, Hearts=3, Spades=4 };
/** the name of the values */                
  enum Values {
               Empty = 0,
               Ace   = 1,
               Two   = 2,
               Three = 3,
               Four  = 4,
               Five  = 5,
               Six   = 6,
               Seven = 7,
               Eight = 8,
               Nine  = 9,
               Ten   = 10,
               Jack  = 11,
               Queen = 12,
               King  = 13,
               HighAce = 14 };
/** create a card with a given value */
  basicCard( Values v, Suits s,  QWidget *parent=0,  bool empty=FALSE); 
/** destructor */
  virtual ~basicCard();

  const QPixmap & pixmap();

private:
  static const char vs[16]; 
  static const char ss[6];  
  static cardMaps *maps; //   The pictures...
  //   Note: we have to use a pointer
  //   because of Qt restrictions.
  //   ( QPainter objects needs a
  //   running QApplication. )
  //   

  Suits suit;
  Values value;
  bool faceup;
  bool empty_flag;
  int direction;

protected:
  void paintEvent( QPaintEvent * );
  void showCard(); 
  void turn(bool faceup = TRUE); 
  void rotate45(int d);

public:
/** return the suit for the card */
    Suits Suit() const {return suit;}     
/** return the value for the card */
    Values  Value() const {return value;} 
/** Converts a low Ace to a HighAce and returns the card value */
    Values  ValueA() const {return value==Ace?HighAce:value;} 
/** returns true if its a red card */
    bool Red() const { return suit==Diamonds || suit==Hearts; }
/** returns tru if its a black card */
    bool Black() const { return suit==Clubs || suit==Spades; }
/** returns true if the card is laying face up */
    bool FaceUp() const {return faceup;}  
/** return a Character symbol for the Value */
    const char vsym() const { return vs[value]; }
/** return a Character symbol for the Suit */
    const char ssym() const { return ss[suit]; }
/** check for an empty card */
    virtual bool empty() const { return empty_flag; }
/** check if the card is movable */
    virtual bool movable() const { return !empty(); }
/** return the rotation state */
  int rotated() { return direction; }
};

basicCard::Suits& operator++(basicCard::Suits& s);
basicCard::Values& operator++(basicCard::Values& v);
#endif

