/***************************************************************************
                          kbill.cpp  -  description
                             -------------------
    begin                : Thu Dec 30 16:55:55 CET 1999
    copyright            : (C) 1999 by Jurrien Loonstra
    email                : j.h.loonstra@st.hanze.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmsgbox.h>

#include "kbill.h"
#include "inputbox.h"
#include "aboutbox.h"
#include "objects.h"
#include "Strings.h"

KBill::KBill(const char *name) : KTMainWindow(name) {
	file = new QPopupMenu();
	file->insertItem(i18n("New game"), this, SLOT(NewGame()));
	pauseid = file->insertItem(i18n("Pause game"), this, SLOT(Pause()));
	file->insertItem(i18n("Warp to level..."), this, SLOT(WarpTo()));
	file->insertItem(i18n("View high scores"), this, SLOT(ViewHighScores()));
	file->insertItem(i18n("Quit game"), this, SLOT(Quit()));

	help = new QPopupMenu();
	help->insertItem(i18n("Story of kBill"), this, SLOT(Story()));
	help->insertItem(i18n("Rules"), this, SLOT(Rules()));
	help->insertItem(i18n("About kBill"), this, SLOT(About()));

	menu = new KMenuBar(this);
	menu->insertItem(i18n("&File"), file);
	menu->insertSeparator();
	menu->insertItem(i18n("&Help"), help);

	field = new Field(this);
	setView(field);

	setMenu(menu);
}

KBill::~KBill() {
}

Field* KBill::getField() {
	return field;
}

// -----------------------------------------------------------------------

void KBill::Quit() {
	field->stopTimer();
	if (KMsgBox::yesNo(this, i18n("Quit"), i18n(quitstr), KMsgBox::QUESTION) == 1) {
		game.quit();
		deleteAll();
		kapp->quit();
	}
	field->startTimer();
}

void KBill::About(){
	field->stopTimer();
	AboutBox about(this);
	about.exec();
	field->startTimer();
}

void KBill::NewGame() {
	field->stopTimer();
	if (KMsgBox::yesNo(this, i18n("New Game"), i18n(newgamestr), KMsgBox::QUESTION) == 1)
		game.start(1);
	else
		field->startTimer();
}

void KBill::Pause() {
	field->stopTimer();
	KMsgBox::message(this, i18n("Pause Game"), i18n(pausestr), 0, i18n("Continue"));
	field->startTimer();
}

void KBill::WarpTo() {
	field->stopTimer();
	InputBox b(this, 0, "Warp To Level", warpstr);
	bool status  = b.exec() == 1;
  field->startTimer();
	if (status) {
		bool ok;
		int level = b.getText().toUInt(&ok);
		if (ok) {
			field->startTimer();
			game.warp_to_level(level);
			return;
		}
	}
}

void KBill::ViewHighScores() {
	ui.popup_dialog(Game::HIGHSCORE);
}

void KBill::Story() {
	field->stopTimer();
	KMsgBox::message(this, i18n("Story"), i18n(storystr), 0);
	field->startTimer();
}

void KBill::Rules() {
	field->stopTimer();
	KMsgBox::message(this, i18n("Rules"), i18n(rulesstr), 0);
	field->startTimer();
}