/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <stdio.h>
#include <kurl.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "level.h"
#include "config.h"
#include "enemy.h"
#include "DebugInfo.h"


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/



//
//      Name:  Level::Level( char *fname )
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
Level::Level( char *fname )
{
  FILE *fp;
  char line[256];
  int xposition,yposition,enemytype;
  
  dprintf( "START::()\n");
  
  
  startPosArr = QPointArray( 100 ); // MAX_ENEMYS );   -->> BUG / BAD
  enemyTArr = QPointArray( 100 ); // MAX_ENEMYS );     -->> BUG / BAD
  nrEntries = 0;
  
  // get the level nr
  KURL kurl( fname );
  if ( sscanf( kurl.filename(), "level_%d.lev", &levelNr ) != 1 )
  {
     fprintf( stderr, "%s: Can't extract level number from Level >%s<. Assume 0.\n",
                      APPNAME, fname );
     levelNr = 0;
  }
  
  // Open the level file and read line by line
  errorNr = 0;
  if (  (fp = fopen( fname, "r" ) ) == NULL )
  {
    errorNr = -1;
    fprintf( stderr, "%s:Can't open level >%s<\n", APPNAME, fname );
  }
  else
  {
    while ( (fgets( line, 255, fp )) != NULL )
    {
      if ( sscanf( line, "%d %d %d", &xposition, &yposition, &enemytype ) == 3 )
      {
        if ( nrEntries < 100 ) // MAX_ENEMYS )  -->> BUG / BAD
        {
           startPosArr.setPoint( nrEntries, QPoint( xposition, yposition ) );
           enemyTArr.setPoint( nrEntries, QPoint( enemytype, 0 ) );
           nrEntries++;       
        }
        else
        {
          fprintf( stderr, "%s: Level >%s< reached max. enemy entries (%d)\n",
                           APPNAME, fname, 100 ); // MAX_ENEMYS );
        }
      }
      else
      {
        fprintf( stderr, "%s: Level >%s<. Corrupt line >%s<. Entry skipped\n",
                         APPNAME, fname, line );        
      }
    }
    fclose( fp );
  }
	  
  dprintf( "END::()\n");
}


//
//      Name:  Level::~Level
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
Level::~Level()
{
  dprintf( "START::()\n");

  dprintf( "END::()\n");
}

  

//
//      Name:  Level::getLevelNr
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
int Level::getLevelNr()
{
  int retValue;
  dprintf( "START::()\n");
  retValue = levelNr;
  dprintf( "END::()=>%d<\n", retValue );
  return( retValue );
}


//                   
//      Name:  Level::getEnemy
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
int Level::getEnemy(int enemyNr, QPoint &startPos, unsigned int &enemyType)
{
  int retValue = 0;
  
  dprintf( "START::()\n");
  
  if ( enemyNr < nrEntries )
  {
    startPos = startPosArr[enemyNr];
    QPoint et=  enemyTArr[enemyNr];
    enemyType = et.x();
  }
  else
  {
    startPos = QPoint(0,0);
    enemyType = 0;
    retValue = -1;
  }

  dprintf( "END::()=>%d<\n", retValue );
  return( retValue );
}

