/***************************************************************************
              TenseEntryPage.h  -  tenses of irreg. verbs dialog page
                             -------------------                                         
    begin                : Sat Nov 27 20:20:34 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef TenseEntryPage_included
#define TenseEntryPage_included

#include "TenseEntryPageData.h"
#include "GrammerManager.h"

class TenseEntryPage : public TenseEntryPageData
{
    Q_OBJECT

public:

    TenseEntryPage
    (
        QDialog           *dlgbook,
        bool               multi_sel,
        const Conjugation &con_prefix,
        const Conjugation &conjugations,
        QWidget           *parent = NULL,
        const char        *name = NULL
    );

    Conjugation getConjugation();

    virtual ~TenseEntryPage();

protected:
    void keyPressEvent( QKeyEvent * );

protected slots:
    virtual void initFocus() const;
    virtual void secondPluralChanged(EA_QTSTR);
    virtual void secondSingularChanged(EA_QTSTR);
    virtual void thirdNSingularChanged(EA_QTSTR);
    virtual void thirdFPluralChanged(EA_QTSTR);
    virtual void thirdMSingularChanged(EA_QTSTR);
    virtual void thirdFSingularChanged(EA_QTSTR);
    virtual void slotTenseSelected(int);
    virtual void thirdMPluralChanged(EA_QTSTR);
    virtual void thirdNPluralChanged(EA_QTSTR);
    virtual void firstSingularChanged(EA_QTSTR);
    virtual void firstPluralChanged(EA_QTSTR);
    virtual void slotThirdSCommonToggled(bool);
    virtual void slotThirdPCommonToggled(bool);
    virtual void slotNextConj();

protected:

    Conjugation  prefix,
                 conjugations;
    QString      selection;
    bool         multi_mode;
};
#endif // TenseEntryPage_included
