/***************************************************************************
       compat-2x.h - provide minimal compatibility for Qt2.x and KDE2.x
                          -------------------
    begin                : Sun Dec 19 11:26:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/************x***************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef COMPAT_2X_H
#define COMPAT_2X_H


// needed for Qt
#ifdef EA_QT2x
# include "qnamespace.h"
# define  EA_QtNS(x)  Qt::x
#else
# define  EA_QtNS(x)  x
#endif

// needed for KDE
#ifdef EA_KDE2x

#include <klocale.h>
#include <kstddirs.h>
#include  <kconfig.h>

# define  EA_KappGetConfig           KApplication::kApplication()->config()
# define  EA_KDEHTMLDIR(path, file)  locate( "html", file)
# define  EA_KDEDATADIR(path, file)  locate( "data", file)

#else

#include <kapp.h>

# define  EA_KappGetConfig           kapp->getConfig()
# define  EA_KDEHTMLDIR(path, file)  (QString) kapp->kde_htmldir()+"/"+path+file
# define  EA_KDEDATADIR(path, file)  (QString) kapp->kde_datadir()+"/"+path+file

#endif

#endif  COMPAT_2X_H
