/***************************************************************************
                          vvoklist.cpp  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "vvoklist.h"
#include <iostream.h>

VVokItem::VVokItem( QListView * parent, VVokabel *Vok )
		: ListEditItem ( parent )
{
	Vokabel = Vok;
}

VVokItem::VVokItem( QListView * parent, QListViewItem * after, VVokabel *Vok )
		: ListEditItem ( parent, after ) 
{
	Vokabel = Vok;
}

VVokItem::~VVokItem(){
}


/** sets text direct in the basic list */
void VVokItem::setText( int Column, const char * Text)
{
	Vokabel->setString( Column, Text );
}


/** returns the text right out of the basic list */
const char *VVokItem::text( int Column ) const
{
	return Vokabel->string( Column );
}

/** returns a pointer to its vokabel */
VVokabel * VVokItem::vokabel()
{
  return Vokabel;
}






VVokList::VVokList( QWidget *parent, const char *name = 0 ) : ListEdit(parent,name)
{
	setMultiSelection ( true );
	setAllColumnsShowFocus ( true );
	
	// initialize the list, create the two columns
  setHScrollBarMode ( AlwaysOff );
	addColumn( 0 );
	addColumn( 0 ); 
	setColumnWidthMode ( TermColumn, QListView::Manual );
	setColumnWidthMode ( TranslationColumn, QListView::Manual );
}


VVokList::~VVokList()
{
}


/**  */
bool VVokList::handleEnterPress( const QKeyEvent *k ) 
{
	if ( !ListEdit::handleEnterPress( k ) && !(k->key() == Key_Tab)) {
	  emit enterPressedLastLine();
	}
	return true;
}


/** appends new vokabel at the end */
void VVokList::appendVokabel( VVokabel *Vokabel, bool UpdateView = true ) 
{
	VVokItem *NewItem;
	if( childCount() == 0 )   	// voklist empty ?
	{	NewItem = new VVokItem( this, Vokabel ); }   // create new item at begin=end
	else                                          // create new item at end
	{ NewItem = new VVokItem( this, lastItem(), Vokabel ); }
	
	if( NewItem )  // new item successfull created?
	{
		NewItem->setup();              // sets lookup height to needed size for display
		if( UpdateView )
		{
			setEditedColumn( 0 );
			setCursorPos( 0 );
			setEditMode();
			
			
  		ensureItemVisible( NewItem );
		  adjustHeaderWidth();
		
			emit justModified();
		}
		setCurrentItem( NewItem ); // also needed for faster tracking (above)
	}
}


/** changes the size of the header to fit in the view
as standard there should be no horizontal Scrollbar */
void VVokList::adjustHeaderWidth( int Width = -1, int Height = -1 )
{
//	cerr << "Weite: " << Width << ", Hhe: " << Height;
	if( Width == -1 ) Width = width();
	if( Height == -1 ) Height = height();
	
	if ( Height < contentsHeight() + header()->height() )
	{
//  cerr << " scroll";
		Width -= verticalScrollBar()->width();
	}
	
//	cerr << " dann Weite: " << Width << ", Hhe: " << Height << "\n";
	
	int LeftWidth = Width / 2;
	int RightWidth = Width - LeftWidth;
	
	if( RightWidth != columnWidth(header()->mapToActual( TranslationColumn )) )
	{
	  setColumnWidth( header()->mapToActual( TermColumn ), LeftWidth );
  	setColumnWidth( header()->mapToActual( TranslationColumn ), RightWidth );
  	header()->resize( Width, header()->height() );
  }

  triggerUpdate();

//	updateEditField();
}




///** ensures correct headersetting */
//void VVokList::show()
//{
//  setUpdatesEnabled( false );
//	
//	ListEdit::show();
//  
//  setUpdatesEnabled( true );
//	
////  cerr << "show ";
//	adjustHeaderWidth();
//  //repaint();
//} 

/** ensures correct headersetting */
void VVokList::resizeEvent ( QResizeEvent * e ) 
{
//  cerr << "re ";
	adjustHeaderWidth( /*e->size().width(), e->size().height()*/ );
	ListEdit::resizeEvent( e );
} 


/** returns the current vok */
VVokabel *VVokList::currentVok()
{
  VVokItem *Item = (VVokItem*)currentItem();
  if( Item ) 
    return Item->vokabel();
  else return 0;
}

/** returns the first selected vok */
VVokabel *VVokList::firstSelectedVok()
{
  SelectedIterator = (VVokItem*)firstChild();
  return nextSelectedVok( true );
}

/** returns the next selected vok */
VVokabel *VVokList::nextSelectedVok( bool first = false )
{
  if( !first ) SelectedIterator = (VVokItem*)SelectedIterator->nextSibling();
  
  while( SelectedIterator ) 
  {
    if( SelectedIterator->isSelected() ) return SelectedIterator->vokabel();
    SelectedIterator = (VVokItem*)SelectedIterator->nextSibling();
  }
  
  return 0; // nothing is selected
}

void VVokList::focusInEvent( QFocusEvent * Event ) 
{
  QListView::focusInEvent ( Event ); 
  
  QString text=QApplication::clipboard()->text();
  emit clipboardHasData( !text.isEmpty() );
}


/**  */
void VVokList::insertText()
{
  QClipboard *Clipboard = QApplication::clipboard();
  EditField->insert( Clipboard->text() );
}


/**  
void VVokList::paintEvent( QPaintEvent * Event )
{
	adjustHeaderWidth();
	ListEdit::paintEvent( Event );
}*/

/** selects all */
void VVokList::selectAll()
{
  VVokItem* Item;
  for( Item = (VVokItem*)firstChild(); Item; Item = (VVokItem*)Item->nextSibling() )  
    { Item->setSelected( true ); }
  triggerUpdate();
}

/** deselects all */
void VVokList::deselectAll()
{
  VVokItem* Item;
  for( Item = (VVokItem*)firstChild(); Item; Item = (VVokItem*)Item->nextSibling() )  
    { Item->setSelected( false ); }
  triggerUpdate();
}

/** inverts Selection */
void VVokList::invertSelection()
{
  VVokItem* Item;
  for( Item = (VVokItem*)firstChild(); Item; Item = (VVokItem*)Item->nextSibling() )  
    { Item->setSelected( !Item->isSelected() ); }
  triggerUpdate();
}
