/***************************************************************************
                          vstring.h  -  description
                             -------------------
    begin                : Tue Feb 15 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VSTRING_H
#define VSTRING_H

#include <qstring.h>
#include <qregexp.h>

/**has some extra abilities like word recognition
  *@author Friedrich W. H. Kossebau
  */

static const char OpenBracket[3]  = { '(', '[', '{'};
static const char CloseBracket[3] = { ')', ']', '}'};
  
class VString : public QString  
{
  public: 
    enum BracketTyp { Round, Angular, Curved };
  	
  	VString();
  	VString( const QString &QS );
  	VString( QRegExp* RegExp );
	  ~VString();
    VString & operator=( const char *str );
	  
    /** removes part that is included by brackets of type bracket */
    VString &delInBrackets( VString::BracketTyp Bracket, int Pos = 0, bool All = false, bool StripOneWhite = true );
    /** finds the  */
    int findWordBegin( int Pos = 0 );
    /** searches word end from pos, returns pos of last letter
        or -1 if nothing found or outside of string */
    int findWordEnd( int Pos = 0 );
    /** searches next word from pos, returns pos of first letter
        or -1 if nothing found or outside of string */
    int findRightWord( int Pos = 0 );
    /** searches next left wordbegin from pos, returns pos of first letter
        or -1 if nothing found or outside of string */
    int findLeftWord( int Pos );
//  protected: //methods
    /** returns true if Letter is in the assigned Letters
        or if there are no Letters assigned is in a..z or A..Z */
    bool isLetter( int Pos );
    
  protected:
    /** */
    QRegExp *Letters;
};

#endif
