/***************************************************************************
    klogindlg.h  -  Logon dialog interface

    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Yury Lebedev
    email                : yurylebedev@mail.ru
    home page            : http://devel-home.kde.org/~ksqlplus
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KLOGINDLG_H
#define KLOGINDLG_H

// platform configuration stuff
#if defined(HAVE_CONFIG_H) && !defined(CONFIG_H)
#define CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qstring.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcombobox.h>

// include KSqlPlusDlg class
#include "ksqlplusdlg.h"

/**
 * Dialog for getting ORACLE login parameters.
 *
 * @author Yury Lebedev
 **/
class KLoginDlg : public QDialog
{
  Q_OBJECT

private:
  /** Username edit */
  QLineEdit* usrEdit;
  /** Password edit */
  QLineEdit* passEdit;
  /** Database edit */
  QLineEdit* dbEdit;
  /** Used SQL*Plus combo box */
  QComboBox* usingCombo;

  /** Stored dialog with local/remote SQL*Plus start parameters */
  KSqlPlusDlg* sqlplusDlg;

public:

  /** Constructs dialog and its internal widgets. */
  KLoginDlg(QWidget* parent = 0, const char* name = 0);
  /** Destructor */
  ~KLoginDlg();

  /** Returns result connect string for ORACLE in their format.
    * It is non-empty if dialog is properly ended. */
  QString connectString();
  /** Returns string with ORACLE 'username@database'.
    * It is non-empty if dialog is properly ended. */
  QString identityString();
  /** Returns name of remote host or empty string
    * if local SQL*Plus is being used. */
  QString remoteHost()
  {
    QString host;
    if( sqlplusDlg->localRemote() ) host = sqlplusDlg->remoteHost();
    return host;
  }

  /** Set up arguments for SQL*Plus process */
  void setupSqlplus(KProcess& proc);

protected:
  /** Restore the parameters from application's config */
  void readOptions();
  /** Save parameters to the application's config */
  void saveOptions();

protected slots:
  /** 'Logon' button slot.
    * Check inputed strings and fill string members. */
  void logon();
  /** Slot for 'using local/remote SQL*Plus' combo */
  void usingActivated(int index);
};

#endif
