/***************************************************************************
                                 DbWork.h
                             -------------------
    begin                : 01.06.1999
    copyright            : (C) 1999 by Ullrich Wagner
    email                : Ullrich.Wagner@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __DB_WORK_H
#define __DB_WORK_H

#include "kstring.h"

class DbWork
{
	public:
	static int connectToOracle(const KString& userid, const KString& password, const KString& connect, KString& oraMessage);
	static void releaseFromOracle();
	static int executeSql(const KString& sqlCommand, KString& oraMessage, int* processedRows, KString& sqlResult, int isSingleCommand = false);
	static int descTable(const KString& tableName, KString& oraMessage, KString& sqlResult);
	static int fillSequenceList(KString& listbox, KString& oraMessage);
	static int getSequenceData(int index, KString& maxValue, KString& minValue, long* increment, KString& cycleFlag);
	static int fillSynonymList(KString& listbox, KString& oraMessage);
	static int getSynonymData(int index, KString& tableOwner, KString& tableName, KString& dbLink);
	static int fillTableList(KString& listbox, KString& oraMessage);
	static int getTableData(int index, KString& oraMessage, KString& tableData);
	static int fillPackageList(KString& listbox, KString& oraMessage);
	static int getPackageData(int index, KString& oraMessage, KString& packageName, KString& packageDeclData, KString& packageDeclDataRaw,
				  KString& packageBodyData, KString& packageBodyDataRaw);
	static KString getPlSqlCompileError(int index, const KString& type);

	private:
	static int alloc_descriptors(int size, int max_vname_len, int max_iname_len, KString& oraMessage);
	static int set_bind_variables(KString& oraMessage);
	static int process_select_list(KString& sqlCommand, KString& oraMessage, KString& sqlResult, int overwrite);
	static void correctSqlStatement(KString& statement);
	static void initTokenList();
	static void replaceSqlTokens(KString& statement);
	static int getPlaceholder(const KString& statement, KString& placeholder);
	static void replacePlaceholder(const KString& placeholder, KString& value);
	static int lookupPlaceholder(const KString& placeholder, KString& value);
	static void remeberPlaceholder(const KString& placeholder, const KString& value);
	static void buildSqlList(const KString& sqlCommands);
	static int getNextSqlCommand(int index, KString& sqlCommandAtIndex);
	static void correctHeader(KString& header, int headerLen);
	static int getItemLength(KString header, int dataLen, int dataType);
	static int getFloatScale(double number);

};

#endif // __DB_WORK_H
