#include <stdlib.h>
#include <stdio.h>
#include <qstring.h>
#include <kwm.h>
#include <kapp.h>

#include "StatusView.h"
#include "mysqlw.h"

#ifndef rcsid
static const char rcsid[]="$Id: StatusView.cpp,v 2.2 1999/07/04 22:30:43 ral Exp $";
const char*statusview_rcs(){return rcsid;}
#endif

#define Inherited CTextViewData

CStatusView::CStatusView(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( "KMySql - StatusView" );
    KWM::setIcon(winId(),kapp->getIcon());
    KWM::setMiniIcon(winId(),kapp->getMiniIcon());
    
    timer = new QTimer(this);
    connect( timer, SIGNAL(timeout()),this, SLOT(RefreshOutput()) );
}


CStatusView::~CStatusView()
{
}

void CStatusView::get_status()
{
    long seconds;
    QString s;
    QString t;
    char *str1, *str2;

    str1 = str2 = NULL;
    if (!sql_server)
	return;
    
    str1 = sql_server->get_status();
    if (!str1)
	return;
    str2 = &str1[8];
    s = str2;
    t = str2;
    t = t.mid(t.find("Thread"),t.length());
    //may be a 3.21 version of mysql
    //it returns another string then 3.22
    if (t.length() == 0) {
	t = str2;
        t = t.mid(t.find('R'),t.length());
    }
    long index = s.find(" ");
    s = s.left(index);
    seconds = s.toLong();
    s.sprintf("Uptime: %ld days %ld hours %ld min ",
	 seconds/86500L,
	 (seconds % 86400L) / 3600L,
	 (seconds % 3600L) / 60L);
    s += t;
    OutputArea->insertLine(s);
    OutputArea->setCursorPosition(OutputArea->numLines(),0);
}

void CStatusView::RefreshOutput()
{
    timer->stop();
    get_status();
    timer->start(60000,TRUE);
}

void CStatusView::hide()
{
    timer->stop();
    QDialog::hide();
}

void CStatusView::show()
{
    RefreshOutput();
    QDialog::show();
}
