/***************************************************************************
                          klistview.h  -  description                              
                             -------------------                                         
    begin                : Wed Aug 4 1999                                           
    copyright            : (C) 1999 by Joachim Ansorg
    email                : Jockel123@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KLISTVIEW_H
#define KLISTVIEW_H

#include <qstring.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qpixmap.h>

/**A class to make porting to QListView from KTreelIst easy.
  *@author Joachim Ansorg
  *@short Class to port a program using KTreeList to QListView
  */

class KListView : public QListView
{
   Q_OBJECT
public: 
	/*Constructor*/
	KListView(QWidget *parent=0, const char *name=0);
	~KListView();
	/*Returns the number of childitems of the given item*/	
	int count(QListViewItem *item);
	/*Returns the index of the current item.*/
	int getCurrentItem(QListViewItem*);
	/*Selectes the item at index and highlightes it*/
	void setCurrentItem(int index);
	/*Adds a childitem to current, selected item in the tree*/
	void addChildItem(QString text, QPixmap pix,int index);
	/*Returns the item at position index*/
	QListViewItem* itemAt(int index);

protected slots:
	/*It's connected with QListView::currentChanged(). In this slot singleSelectd is emitted.*/
	void slotSelected(QListViewItem*);
	
signals:
	/*It's emited when the user selected an item in the tree.*/
	void singleSelected(int);
};

#endif








