/***************************************************************************
                    cdocbrowser.h - a htmlview for kdevelop
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/* $Header: /cvs/bibletime/bibletime/bibletime/cdocbrowser.h,v 1.7 1999/11/10 22:45:53 jockel Exp $ */
/* $Revision: 1.7 $ */

#ifndef CDOCBROWSER_H
#define CDOCBROWSER_H

//includes for Qt
#include <qwidget.h>
#include <qstring.h>
#include <qtabdialog.h>
#include <qcombobox.h>
#include <qstrlist.h>
#include <qpopupmenu.h>
#include <qframe.h>
#include <qregexp.h>

//includes for KDE
#include <htmlview.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kconfig.h>
#include <kurl.h>
#include <kprocess.h>

#include "bibletimedoc.h"
#include "finddlg.h"

/** 
  *the documentation browser, attention!: only a prototype
  *@author Sandy Meier
  */
class CDocBrowser : public KHTMLView
{
  Q_OBJECT 
public:
  /** constructor
  	*/
  CDocBrowser(QWidget*parent=0,const char* name=0); 

  /** destructor
  	*/
  ~CDocBrowser();

  /** show a html in a htmlview,if reload true it reload a file even it is in memory
  	*
  	*/
  void showURL(QString url,bool reload=false);

  void setDocBrowserOptions();
  QString currentURL();
	QString currentTitle();
	QPopupMenu* popup(){ return doc_pop; };	
	
	/** build the entries of the RB click
		*/
	void buildSearchMenu( ModuleDefinitionList* );
  /** Returns the displayed text
		* @return The current text of the widget
		*/
  virtual QString getDisplayedText();

  /**
  	*/
  virtual void write( const char* _text);
  /**
  	*/
  virtual void saveToFile( QString text);


public slots:
	/** gets called when an item from the RB menu was chosen
		*/
	void slotPopupItemChosen(int);
  void slotDocFontSize(int);
  void slotDocStandardFont(const char *);
  void slotDocFixedFont(const char *);
  void slotDocColorsChanged(const QColor&, const QColor&,
		 	  const QColor&, const QColor&, const bool);
  void slotPopupMenu( KHTMLView *, const char *, const QPoint & );
  void slotCopyText();
  void slotPrintTextWithKey();
  void slotPrintTextWithoutKey();
  void slotSearchTextBegin();
  void slotSearchTextEnd();
  /** search text in browser widget */
  void slotSearchText(const QRegExp&);
	void slotSetFileTitle(const char* title);
	void slotViewInKFM();
  /**  */
  void slotRefreshLinkLists();
		
 signals:
	void sigSearchInModule(const QString &moName, const QString &search);	
	void sigPrintText( const QString&, bool, const QString&, bool );
  void sigActivateModule( const QString& );
		
protected:
#if KDE_VERSION_RELEASE < 5	//check if KDE is earlier than 1.1.2
  /** From kdecore. Contains a bugfix related to resizing the scrollbars
  	*/
  void calcScrollBars();
#endif
  void resizeEvent(QResizeEvent *event);

  QString old_url, complete_url, old_file;
  QString m_title, m_refTitle;
	QPopupMenu* doc_pop;
  QPopupMenu*	lookup_pop;
	
	QStrList	*extensionList;
	QStrList	*commandList;
  QString 	currentText;
	
	KProcess process;

protected slots: // Protected slots
  /**
  	*/
  void slotSaveAsTextFile();

  /**
  	*/
  void slotSaveAsHTMLFile();
	
private:
	// html view preferences
	static int  fSize;
	static QString standardFont;
	static QString fixedFont;
	
	static QColor bgColor;
	static QColor textColor;
	static QColor linkColor;
	static QColor vLinkColor;
	static bool   underlineLinks;
	static bool   forceDefaults;
	
  KFindTextDialog 			*searchDialog;
	ModuleDefinitionList	*_moduleList;

};


//-----------------------------------------------------------------------------
// Adapted from options.h & options.cpp of
//
// KDE Help Options
//
// (c) Martin R. Jones 1996
//
//-----------------------------------------------------------------------------

class CDocBrowserFont : public QWidget
{
	Q_OBJECT

public:
	CDocBrowserFont( QWidget *parent = 0, const char *name = 0);
	void writeOptions();

public slots:
	void	slotApplyPressed();
	void	slotFontSize( int );
	void	slotStandardFont( const char *n );
	void	slotFixedFont( const char *n );

signals:
	void	fontSize( int );
	void	standardFont( const char * );
	void	fixedFont( const char * );

private:
	void	readOptions();
	void	getFontList( QStrList &list, const char *pattern );
	void	addFont( QStrList &list, const char *xfont );

private:
	int	fSize;
	QString	stdName;
	QString	fixedName;
	QStrList standardFonts;
	QStrList fixedFonts;
};

//-----------------------------------------------------------------------------

class CDocBrowserColor : public QWidget
{
	Q_OBJECT
public:
	CDocBrowserColor( QWidget *parent = 0, const char *name = 0 );
  void writeOptions();

signals:
	void	colorsChanged( const QColor&, const QColor&,const QColor&, const QColor&, const bool);
  void 	sigChangeColors();
 	
protected slots:
	void	slotApplyPressed();
	void	slotBgColorChanged( const QColor &col );
	void	slotTextColorChanged( const QColor &col );
	void	slotLinkColorChanged( const QColor &col );
	void	slotVLinkColorChanged( const QColor &col );
	void  slotUnderlineLinksChanged( bool uline );
	void	slotVerseColorChanged(const QColor &col);	
	void	slotVersenumberColorChanged(const QColor &col);

private:
	void	readOptions();

private:
	QColor bgColor;
	QColor textColor;
	QColor linkColor;
	QColor vLinkColor;
	QColor verseColor;	
	QColor versenumberColor;
	bool   underlineLinks;
	bool   changed;
};

#endif








