/*
    File: texttoolbar.cpp
    Version: 0.2.4
    Date: 31-DEC-1998
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>

    The TextToolBar shows the total amount of received and
    transmitted data and the time spend online.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#include "texttoolbar.h"
#include "iostream.h"


TextToolBar::TextToolBar(smif* serialmon,QWidget* parent=0) :
  KToolBar(parent),serialmon(serialmon) {

  setFullWidth(false);

  // init TX amount label
  txtext=new QLabel("Text",this);
  txtext->setFont(QFont("System",10,QFont::Bold));
  txtext->setAlignment(AlignLeft|AlignVCenter);
  txtext->show();
  txtext->resize(69,24);
  insertWidget(0,69,txtext);

  // init RX amount label
  rxtext=new QLabel("Text",this);
  rxtext->setFont(QFont("System",10,QFont::Bold));
  rxtext->setAlignment(AlignHCenter|AlignVCenter);
  rxtext->show();
  rxtext->resize(69,24);
  insertWidget(1,69,rxtext);

  // init online time label
  tmtext=new QLabel("OFFLINE",this);
  tmtext->setFont(QFont("System",10,QFont::Bold));
  tmtext->setAlignment(AlignRight|AlignVCenter);
  tmtext->show();
  tmtext->resize(69,24);
  insertWidget(2,69,tmtext);

  // connect smif-update-signal with text-update-slots
  connect(serialmon,SIGNAL(TXcountChanged(float)),this,SLOT(updateTX(float)));
  connect(serialmon,SIGNAL(RXcountChanged(float)),this,SLOT(updateRX(float)));
  
  connect(serialmon,SIGNAL(DCDstatusChanged(bool)),
	  this,SLOT(DCDchanged(bool)));

};



// update TX

void TextToolBar::updateTX(float value) {

  int val=(int)value;
  QString buffer;

  if(val<CHTXRX1K) {
    buffer.sprintf("%i",val); 
  }
  else if(val<CHTXRX1M) {
    buffer.sprintf("%3.1f k",(float)val/CHTXRX1K);
  }
  else {
    buffer.sprintf("%3.1f M",(float)val/CHTXRX1M); 
  };
  txtext->setText("TX: "+buffer);  

  txtext->repaint(false);

};



// update RX

void TextToolBar::updateRX(float value) {

  int val=(int)value;
  QString buffer;

  if(val<CHTXRX1K) {
    buffer.sprintf("%i",val); 
  }
  else if(val<CHTXRX1M) {
    buffer.sprintf("%3.1f k",(float)val/CHTXRX1K);
  }
  else {
    buffer.sprintf("%3.1f M",(float)val/CHTXRX1M); 
  };
  rxtext->setText("RX: "+buffer);  

  rxtext->repaint(false);

};



// update online timer

void TextToolBar::updateTime() {

  tmtext->setText((QTime().addMSecs(online.elapsed())).toString());
  tmtext->repaint(false);
  
};



// update online-timer

void TextToolBar::DCDchanged(bool state) {
  if(state) {
    online.start();
    connect(serialmon,SIGNAL(updated()),this,SLOT(updateTime()));
  }
  else {
    disconnect(serialmon,SIGNAL(updated()),this,SLOT(updateTime()));    
    tmtext->setText("OFFLINE");
    tmtext->repaint(false);
  };
};

