/*
    File: bar.h
    Version: 0.2.1
    Date: 1998/14/01
    Copyright: Bernhard Kuhn <kuhn@lpr.e-technik.tu-muenchen.de>
    
    This is a vertical bar with frame to display values ;-)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/



#ifndef BAR_H
#define BAR_H



#include <qframe.h>
#include <qdrawutl.h>



// define standard colors for bar

#define BAR_STD_SET green
#define BAR_STD_CLR black



// define class for bar-widget

class bar: public QFrame {

  // this class is an QOBJECT
  Q_OBJECT;
  
public:

  // constructor
  bar(QWidget* parent=0,float maximum=1,char* name="",
    QColor setColor=BAR_STD_SET,QColor clrColor=BAR_STD_CLR);

protected:

  // what to to when bar should be repainted
  void drawContents(QPainter* p);
  
private:

  // current state (0 <= value <= 1)
  float value;

  // maximum value
  float maximum;

  // brush for enabled part of bar
  QBrush setBrush;
  
  // brush for disabled part of bar
  QBrush clrBrush;

public slots:

  // change bar value
  void setBar(float newValue);

  // change maximum value
  void setMaximum(float newMaximum);
   
};



#endif
