/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [te_common.h]                 Common Definitions                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef TECOMMON_H
#define TECOMMON_H

// to keep this module independ from QT
// FIXME: Questionable

#ifndef BOOL
typedef int BOOL;
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef UINT8
typedef unsigned char UINT8;
#endif

#ifndef UINT16
typedef unsigned short UINT16;
#endif

// Attributed Character Representations ///////////////////////////////

// Colors

#define BASE_COLORS   8
#define INTENSITIES   2
#define TABLE_COLORS  (INTENSITIES*BASE_COLORS)
#define ALL_COLORS    (2+TABLE_COLORS)
#define DEFAULT_FORE_COLOR 0
#define DEFAULT_BACK_COLOR 1

class ca
// Hmm, i'm tricky about this structure.
// In TEDisplay (ansiterm.cpp) i use the fact that this is an 
// `int' on i386 to speed up comparisons.
// FIXME: should make proper compare operations instead.
{
public:
  UINT16 c; // character
  UINT8  f; // foreground color
  UINT8  b; // background color
//FIXME: add additional attributes like `underlined' etc.
};

#endif // TECOMMON_H
