/* 
  Copyright (c) 1999 js <jonny@dillingen.baynet.de>
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/netcom.h,v 1.3 1999/03/06 18:01:53 jonny Exp $

*/
#ifndef _NETCOM_H
#define _NETCOM_H

#include <qbuffer.h>
#include <qstring.h>
#include <qlist.h>

class KExtSocket : public KSocket {

 public:
  KExtSocket(const char *_host, int _port);

  QString readLine();
  QString* sendbuffer(const char *buf);
  void writeLine(const QString &str);
};

class NetCom {

 public:
  NetCom(const char *_host, int _port = 4559);
  ~NetCom();

  int login(const char *uname);
  QString getReceived(const char *name);
  QBuffer *getFile(const char *dir, const char *name);
  QString sendBuffer(QBuffer *buffer);
  QString command(const char *cmd);
  QList<QString> readDir(const char *dir);
  int getFileCount(const char *dir);

  enum STATUS {
    CONNECTION_ALREADY_OPEN  = 125,
    ABOUT_TO_OPEN_DATACON    = 150,
    COMMAND_OK               = 200,
    COM_NOT_IMPL_SUPERFLUOUS = 202,
    SYSTEM_STATUS            = 211,
    DIRECTORY_STATUS         = 212,
    FILE_STATUS              = 213,
    HELP_MESSAGE             = 214,
    CLOSING_CONNECTION       = 221,
    CLOSING_DATA_CONNECTION  = 226,
    USER_LOGGED_IN           = 230,
    FILE_ACTION_OK           = 250,
    NEEDS_PASSWD             = 331,
    NEEDS_ACCOUNT            = 332,
    SERVICE_NOT_AVAILABLE    = 421,
    NO_DATA_CONNECTION       = 425,
    CONNECTION_CLOSED        = 426,
    FILE_ACTION_NOT_TAKEN    = 450,
    ACTION_ABORTED_ERROR     = 451,
    ACTION_NOT_TAKEN_SPACE   = 452,
    FAILED_TO_KILL_JOB       = 460, 
    SYNTAX_ERROR_COMMAND     = 500,
    SYNTAX_ERROR_PARAMETER   = 501,
    COMMAND_NOT_IMPLEMENTED  = 502,
    BAD_COMMAND_SEQUENCE     = 503,
    OPERATION_NOT_PERMITTET  = 504,
    NOT_LOGGED_IN            = 530,
    NEED_ACC_FOR_STORING     = 532,
    ACTION_NOT_TAKEN         = 550,
    ACTION_ABORTED_PAGETYPE  = 551,
    FILE_ACTION_ABORTED      = 552,
    ACTION_NOT_TAKEN_NAME    = 553
 };

 private:
  int check(const QString &str);
  QString* makePORT(int iaddr[], int port);
  QByteArray *getInetAddr();
  void parsePassiveReply(const QString &reply, QString &hostname, int &port);
  KExtSocket *openPassiveConnection();

  KExtSocket *sock;
};

#endif _FAX_STATUS_WIDGET_H



