/***************************************************************************
                          khylainfo.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 1999                                           
    copyright            : (C) 1999 by Jonas Sextl                         
    email                : jonny@dillingen.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include <qpainter.h>
#include <iostream.h>
#include <kmsgbox.h>
#include <kwm.h>

#include "khylainfo.h"
#include "khylafax.h"

#include "khylainfo.moc"

KHylaInfo::KHylaInfo(QWidget *parent=0, const char *name=0, WFlags f=0)
	: QWidget (parent, name, f)
{
	newfaxpending = false;
	
	conf = kapp->getConfig();
	conf->sync();

	conf->setGroup("Transmission Preferences");
	netcom = new NetCom(conf->readEntry("Hostname", "localhost"));

	khf = new KHylaFax(netcom);
	
	conf->setGroup("Misc Preferences");
	if(conf->readBoolEntry("Dock", false))
	{
		menu = new KPopupMenu("KHylafax");
		menu->insertItem("Open", this, SLOT(open()));
		menu->insertItem("Preferences", this, SLOT(prefs()));
		menu->insertItem("Receviced Facsimiles", this, SLOT(status()));
		menu->insertSeparator();
		//menu->insertItem("Reset History", this, SLOT(reset()));
		//menu->insertSeparator();
		menu->insertItem("Quit", this, SLOT(quit()));
	
		KWM::setDockWindow(this->winId());
		show();
	}
	else
	{
		khf->show();
	}
	
	// TODO: make username configurable
	conf->setGroup("Transmission Preferences");
	if(netcom->login(conf->readEntry("Username", "nobody")) != NetCom::USER_LOGGED_IN) {
		KMsgBox::message(this, "Fehler", "Can't login :-(");
	}
	
	conf->setGroup("Misc Preferences");
	if(conf->readBoolEntry("Autocheck", false)) {
		timer_interval = conf->readNumEntry("Autocheckinterval", 60);
		timer_interval *= 1000*60; /* cause we have to specify milliseconds
					      and the value in the conf is in minutes */
		//timer_interval *= 100;	// for debugging
		faxcount = netcom->readDir("recvq").count();
		tid = startTimer(timer_interval);
	}
}

KHylaInfo::~KHylaInfo()
{
	delete khf;
}

void KHylaInfo::timerEvent(QTimerEvent *e)
{
	if(e->timerId() == tid) {
		/* rescan server receive list */
		//int newcount = netcom->readDir("recvq").count();
		int newcount = netcom->getFileCount("recvq");
		// cout << "count = " << newcount << endl;
		if(newcount != faxcount) {
			faxcount = newcount;
			newfaxpending = true;
			repaint();
			KMsgBox::message(this, "New Fax", "New fax arrived!");
		}
	}
}

void KHylaInfo::mouseReleaseEvent (QMouseEvent *e)
{
	if (e->button()==RightButton) {
		menu->popup(QPoint(this->x(), this->y()),6);
		menu->exec();
	}
}

void KHylaInfo::paintEvent( QPaintEvent * )
{
	QPainter p;
        p.begin( this );
	p.setWindow(0,0,24,24);
        p.setPen( black );
        if(newfaxpending)
	        p.setBrush( red );
	else
		p.setBrush( green );
        p.drawEllipse( 3,3, 15,15 );
        p.end();
}

void KHylaInfo::mouseDoubleClickEvent (QMouseEvent *)
{
	open();
}

void KHylaInfo::open()
{
	newfaxpending = false;
	repaint();
	khf->show();
	khf->raise();
}

void KHylaInfo::quit()
{
	conf->sync();
	kapp->quit();
}

void KHylaInfo::status()
{
	newfaxpending = false;
	repaint();
	khf->menuCallback(ID_VIEW_FAXSTATUS);
}

void KHylaInfo::prefs()
{
	khf->menuCallback(ID_VIEW_PREFERENCES);
}






