/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/khylafax.h,v 1.1.1.1 1999/02/25 15:28:10 jonny Exp $

*/
#ifndef _FAXWIDGET_H
#define _FAXWIDGET_H

#include <qlist.h>
#include <qmlined.h>
#include <qlistbox.h>

#include <kfm.h>
#include <ktopwidget.h>
#include <kapp.h>

#define ID_FILE_CLOSE 6
#define ID_FILE_NEWFAX 7
#define ID_FILE_SENDFAX 8
#define ID_FILE_QUIT 9
#define ID_FILE_FILEUP 15
#define ID_FILE_FILEDOWN 16

#define ID_EDIT_COPY 50
#define ID_EDIT_PASTE 51
#define ID_EDIT_CUT 52

#define ID_VIEW_TOOLBAR 60
#define ID_VIEW_PREFERENCES 61
#define ID_VIEW_FAXSTATUS 62

#define ID_HELP_ABOUT 100
#define ID_HELP_HELP  101

#include "netcom.h"

class KHylaFax : public KTopLevelWidget {
  Q_OBJECT
    
 public:
  KHylaFax(NetCom *netcom);
  ~KHylaFax();
  
  typedef struct coverPage {
    QLabel *faxNumLab;
    QLineEdit *faxNum;
    QLabel *phoneNumLab;
    QLineEdit *phoneNum;
    QLabel *rcptLab;
    QLineEdit *rcpt;
    QLabel *companyLab;
    QLineEdit *company;
    QLabel *locationLab;
    QLineEdit *location;
    QLabel *subjectLab;
    QLineEdit *subject;
    QLabel *transmitLab;
    QPushButton *transmitBut;
    QLabel *memoLab;
    QMultiLineEdit *memo;
  } coverPage;

 public slots:
  void menuCallback(int);
  void addFaxFile();
  void removeFaxFile();
  void clearFaxFile();
  void setTransmitTime();
  int sendFax(KConfig *config);
  
 private:
  
  KMenuBar *menu;
  KToolBar *toolbar;
  QFrame *topLayout;
  
  coverPage *cover;
  QListBox *fileList;
  QLabel *fileListLab;
  KConfig *config;

  NetCom *netcom;

 protected:
  static QList<KHylaFax> windowList;
  int init();
  void closeEvent ( QCloseEvent *e);
};

#endif


