/***************************************************************************
                          qslmarkoutdlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 23 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qslmarkoutdlg.h"

QslMarkOutDlg::QslMarkOutDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	setCaption(i18n("Mark QSL cards as out"));
	
	group = new QButtonGroup();
	group->insert(allButton,QSLOUT_ALL);
	group->insert(buroButton,QSLOUT_BURO);
	group->insert(direktButton,QSLOUT_DIREKT);
	group->setButton(QSLOUT_ALL);
	auswahl = QSLOUT_ALL;
	
	connect(group,SIGNAL(clicked(int)),this,SLOT(slotAuswahl(int)));
	connect(okButton,SIGNAL(clicked()),this,SLOT(slotOk()));
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(slotCancel()));
}

QslMarkOutDlg::~QslMarkOutDlg(){
	delete group;
}

void QslMarkOutDlg::slotAuswahl(int nr)
{
	auswahl = nr;
}

void QslMarkOutDlg::slotOk()
{	
	done(auswahl);
}

void QslMarkOutDlg::slotCancel()
{
	done(QSLOUT_NON);
}

	





