/***************************************************************************
                          qslinwahldlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Aug 23 1999                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qslinwahldlg.h"

QslInWahlDlg::QslInWahlDlg(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
	
	setCaption(i18n("QSL incomming"));
	qsoListe = new LogListView(this);
	qsoListe->setGeometry(20,30,310,180);
	qsoListe->createQslInView();
	
	connect(qsoListe,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(slotSelect(QListViewItem *)));
	connect(chooseButton,SIGNAL(clicked()),this,SLOT(slotChoosen()));
	connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(newButton,SIGNAL(clicked()),this,SLOT(slotNew()));
	
}

QslInWahlDlg::~QslInWahlDlg(){
	delete qsoListe;
}

void QslInWahlDlg::init(LogBook *alog,QList<CQso> *liste)
{
	CQso *qso;
	QString qslInfo;
	CBand banddata;
	CMode modedata;
	QListViewItem *oldItem;
	
	log = alog;
	oldItem = NULL;
	trefferListe = liste;
	trefferListe->first();
	while( (qso = trefferListe->current()) )
	{
		if(qso->GetQslEin())
			qslInfo = "Tnx Qsl";
		else
			qslInfo = "Pse Qsl";
		
		oldItem =  new QListViewItem(qsoListe,oldItem,qso->datum.get(DTAUS_SHORT),qso->utc.get(true),qso->GetCall(),
			banddata.band(qso->GetBand()),modedata.mode(qso->GetMode()),qslInfo);
			qsoListe->addItemPointer(oldItem);
		trefferListe->next();
	}
	qsoListe->setSelected(qsoListe->firstChild(),true);
	qsoListe->setFocus();
}
				
//
// Slots
//-------

void QslInWahlDlg::slotSelect(QListViewItem *item)
{
	CQso *qso;
	long nr;
	nr = (qsoListe->itemPos(item) / item->height());
	qso = trefferListe->at(nr);
	qso->SetQslEin();
	log->setAktQso(qso);
	done(QSLIN_OK);
}

void QslInWahlDlg::slotChoosen()
{
	CQso *qso;
	QListViewItem *item;
	long nr;
	
	item = qsoListe->currentItem();
	nr = (qsoListe->itemPos(item) / item->height());
	qso = trefferListe->at(nr);
	qso->SetQslEin();
	log->setAktQso(qso);
	done(QSLIN_OK);
}

void QslInWahlDlg::slotNew()
{
	done(QSLIN_NEW);
}
		
	


















