/***************************************************************************
                          dhlogdoc.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include <dhlogdoc.h>
#include "dhlog.h"
#include "dhlogview.h"
// Dialoge einbinden
#include "jumpqsodlg.h"
#include "calleditdlg.h"
#include "qsoeditdlg.h"
#include "qsloutdlg.h"
#include "qslmarkoutdlg.h"
#include "qslindlg.h"
#include "ontimelog.h"

QList<DHLogView>* DHLogDoc::viewList = 0L;

DHLogDoc::DHLogDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<DHLogView>;
	viewList->setAutoDelete(true);
	log = NULL;
}

DHLogDoc::~DHLogDoc()
{
}

void DHLogDoc::addView(DHLogView* m_pView)
{
	viewList->append(m_pView);
}

void DHLogDoc::removeView(DHLogView* m_pView)
{
	viewList->remove(m_pView);
}
const QString& DHLogDoc::getPathName() const
{
	return m_path;
}

void DHLogDoc::slotUpdateAllViews(DHLogView* pSender)
{
	DHLogView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				{
					w->repaint();
					w->UpdateView(-1);	// aktuelles Qso
				}
		}
	}

}

void DHLogDoc::pathName( const char* path_name)
{
	m_path=path_name;
}
void DHLogDoc::title( const char* title)
{
	m_title=title;
}

const QString& DHLogDoc::getTitle() const
{
	return m_title;
}

bool DHLogDoc::saveModified()
{
	if(b_modified)
	{
		DHLogApp* win=(DHLogApp*) parent();
  	int want_save = KMsgBox::yesNoCancel(win,
  									i18n("Warning"),	i18n("The current file has been modified.\nDo you want to save it?"));
   	switch(want_save)
    {
    	case 1:
    		if(m_title == "Untitled")
    			win->slotFileSaveAs();
    		else
	     		saveDocument(getPathName());
       	
       	deleteContents();
        return true;
        break;
  		case 2:
    		setModified(false);
      	deleteContents();
  			return true;
  			break;	
  		case 3:
  			return false;
  			break;
  		default:
  			return false;
  			break;
  	}
	}
	else
		return true;

}

void DHLogDoc::closeDocument()
{
	deleteContents();
}

bool DHLogDoc::newDocument()
{
	
	/////////////////////////////////////////////////
	// TODO: Add your document initialization code here
	/////////////////////////////////////////////////
	b_modified=false;
	m_path=QDir::homeDirPath();
	m_title="Untitled";
	if(log) delete log;
	log = new LogBook();
	log->LogInit();
	slotUpdateAllViews(NULL);
	return true;
}

bool DHLogDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	m_title=fileInfo.fileName();
	m_path=fileInfo.absFilePath();
	
	if(log) delete log;
	log = new LogBook();
	if(log->LogLaden(filename) != true)
	{
		KMsgBox::message(NULL,i18n("Open Log"),i18n("Cannot open logbook file."));
		return false;
	}
	
	b_modified=false;
	slotUpdateAllViews(NULL);
	return true;
}

bool DHLogDoc::saveDocument(const char* filename, const char* format)
{
	if(log->LogSpeichern(filename))	
		b_modified=false;
	else
	{
		KMsgBox::message(NULL,i18n("Saving Log"),i18n("Could not save actual Log."));
	}	
	return true;
}

void DHLogDoc::setConfig(KConfig *aconfig)
{
	config = aconfig;
}

void DHLogDoc::deleteContents()
{
	if(log) delete log;
	log = NULL;
}

// Menus abarbeiten
//##################

void DHLogDoc::sortLog()
{
	CQso* tausch;
	
	if(log->anzQso() <= 2) return;	// nur zwei Qsos ?
	tausch = new CQso();
	log->LogSort(1,log->anzQso(),tausch);
	delete tausch;
	b_modified = true;
	slotUpdateAllViews(NULL);
}


void DHLogDoc::editDeleteQso()
{
	if(KMsgBox::yesNo(NULL,i18n("Deleting Qso"),i18n("Are you sure deleting actual Qso ?"),
		    KMsgBox::QUESTION | KMsgBox::DB_SECOND) == 1)
	{
		b_modified = log->DeleteQso(log->aktQso());
		slotUpdateAllViews(NULL);
	}
}

void DHLogDoc::editBeginning()
{
	if(log->anzQso() >= 1)
		log->setAktQso(1);
	slotUpdateAllViews(NULL);
}

void DHLogDoc::editEnding()
{
	if(log->aktQso() < log->anzQso())
		log->setAktQso(log->anzQso());
	slotUpdateAllViews(NULL);
}

void DHLogDoc::editPrev()
{
	if(log->aktQso() > 1)
		log->setAktQso(log->aktQso() - 1);
	slotUpdateAllViews(NULL);
}

void DHLogDoc::editNext()
{
	if(log->aktQso() < log->anzQso())
		log->setAktQso(log->aktQso() + 1);
	slotUpdateAllViews(NULL);
}


void DHLogDoc::editJump()
{
	JumpQsoDlg *dlg;
	long newqso;
		
	dlg = new JumpQsoDlg();
	dlg->setMaxQso(log->anzQso());
	newqso = dlg->exec();
	if(dlg) delete dlg;
	if(newqso != 0)
		log->setAktQso(newqso);
	slotUpdateAllViews(NULL);
}	

void DHLogDoc::editQso()
{
	CQso* qso;
	QsoEditDlg* dlg;
	
	if((qso = log->GetQso(log->aktQso())) == NULL) return; 	// kein Qso da !
	dlg = new QsoEditDlg();
	dlg->editQso(log,qso);
	if(dlg->exec()) b_modified = true;
	if(dlg) delete dlg;
	slotUpdateAllViews(NULL);
}

void DHLogDoc::editCall()
{
	CCall *call;
	CQso *qso;
	CallEditDlg* dlg;
	
	if((qso = log->GetQso(log->aktQso())) == NULL) return;	// kein Qso da !
	call = log->SearchCall(qso);
	dlg = new CallEditDlg();
	
	if(call != NULL)
		{
			dlg->setCaption(i18n("Edit Call"));
			dlg->SetCallRef(call);
			if(dlg->exec() == true) b_modified = true;
		}
	else
		{
			char dummy[20];
			call = new CCall();
			call->SetCall(qso->GetCall(false,dummy));
			dlg->SetCallRef(call);
			dlg->setCaption(i18n("Create new Call"));
			if(dlg->exec() == true)
				{
					log->AddCall(call);
				   b_modified = true;
				 }
			else
				delete call;
		}
		
	if(dlg) delete dlg;
	slotUpdateAllViews(NULL);
}

void DHLogDoc::loggingNew()
{
	CQso* qso;
	QsoEditDlg* dlg;
	
	qso = new CQso();
	dlg = new QsoEditDlg();
	dlg->newQso(config,log,qso);
	if(dlg->exec())
		{
			log->AddQso(qso);
			log->setAktQso(log->anzQso());
			b_modified = true;
		}
	else
		delete qso;
	delete dlg;
	slotUpdateAllViews(NULL);
}

void DHLogDoc::loggingOnTime()
{
// Logbuchmelting, mal irgendwann hier entnehmen...
/*	KMsgBox::message(NULL,"OnTimeLog","Logbuchmelting...");
	LogBook newLog;
	CQso *qso,*newQso,*hQso;
	bool ic;
	long x,y;

	newLog.LogInit();
	newLog.LogLaden("/home/holgu/afu/log/DL0LSJ.dhl");
	x = newLog.anzQso();
	while(x > 0)
	{
		qso = newLog.GetQso(x);
    	ic = false;
		y = log->anzQso();
		while(y > 0)
		{
			hQso = log->GetQso(y);
			if( strcmp(hQso->GetCall(true),qso->GetCall(true)) == 0)
			{
				if( (hQso->GetMode() == qso->GetMode()) && (hQso->GetBand() == qso->GetBand()) )
					ic = true;
			}
			y--;
		}
		if(ic == false)
		{
			newQso = new CQso();
			*newQso = *qso;
			log->AddQso(newQso);
		}
		x--;
	}
	newLog.LogSchliessen();
	*/	
	OnTimeLog *dlg;
	CQso *qso;
	CCall *calldata;
	qso = new CQso();
	calldata = NULL;
	int return_code;
	
	dlg = new OnTimeLog();
	dlg->newQso(config,log,qso,calldata);
	return_code = dlg->exec();
	if(return_code >= 1)
	{
		log->AddQso(qso);
		log->setAktQso(log->anzQso());
		b_modified = true;	
		if(return_code == ONTIMELOG_CALLNEW)
		{
			char dummy[20];
			calldata = dlg->getNewCall();
			calldata->SetCall(qso->GetCall(false,dummy));
			log->AddCall(calldata);
		}
	}
	else
	{
	   delete qso;
	   delete calldata;
	 }
	delete dlg;
	slotUpdateAllViews(NULL);
}


void DHLogDoc::qslIn()
{
	QslInDlg *dlg;
	
	dlg = new QslInDlg();
	dlg->init(config,log);
	while(dlg->exec() != 0)
	{
		slotUpdateAllViews(NULL);
		dlg->clearAll();
		b_modified = true;
	}
	delete dlg;
	slotUpdateAllViews(NULL);
}

void DHLogDoc::qslOut()
{
	QslOutDlg *dlg;

	dlg = new QslOutDlg();
	dlg->Init(log);
	dlg->exec();
	delete dlg;
	
	slotUpdateAllViews(NULL);
}

void DHLogDoc::qslSetOut()
{
	QslMarkOutDlg *dlg;
	int result;
	
	dlg = new QslMarkOutDlg();
	result = dlg->exec();
	if(result != QSLOUT_NON)
	{
		log->MarkQslOut(result);
		b_modified = true;
	}
	delete dlg;
	slotUpdateAllViews(NULL);
}













































