/***************************************************************************
                          dhlog.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 22 17:36:34 MEST 1999
                                           
    copyright            : (C) 1999 by Henning Folger                         
    email                : hf@holgu.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/



#ifndef DHLOG_H
#define DHLOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qlist.h>
#include <qstring.h>

// include files for KDE
//#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "dhlogview.h"
#include "dhlogdoc.h"
#include "resource.h"
#include "logbook.h"
#include "qso.h"
// standard includes
#include <stdio.h>
#include <ctype.h>
#include <time.h>

// forward declaration of the DHLog classes
class DHLogDoc;
class DHLogView;




/**
  * The base class for DHLog application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of DHLogView creates your center view, which is connected
  * to the window's Doc object.
  * DHLogApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
	* @see KTMainWindow
	* @see KApplication
	* @see KConfig
	* @see KAccel
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
  */
class DHLogApp : public KTMainWindow
{
  Q_OBJECT

  friend class DHLogView;

public:
  /** construtor of DHLogApp, calls all init functions to create the application.
    * @see initMenuBar initToolBar
    */
  DHLogApp();

  ~DHLogApp();
  /** enables menuentries/toolbar items
  	*/
  void enableCommand(int id_);
  /** disables menuentries/toolbar items
  	*/
  void disableCommand(int id_);
	/** add a opened file to the recent file list and update recent_file_menu
		*/
	void addRecentFile(const char* file);
	/** opens a file specified by commandline option
		*/
	void openDocumentFile(const char* _cmdl);
	/** returns a pointer to the current document connected to the KTMainWindow instance and is used by
		* the View class to access the document object's methods
		*/	
	DHLogDoc* getDocument() const; 	
protected:
 	/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
		* file
		*/ 	
	void saveOptions();
	/** read general Options again and initialize all variables like the recent file list
	  */
	void readOptions();
	/** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
		* @see KAccel
		*/
	void initKeyAccel();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
  	* @see KApplication#getHelpMenu
  	*/
  void initMenuBar();
  /** this creates the toolbars.
    */
  void initToolBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel.
  	*/
  void initStatusBar();
	/** initializes the document object of the main window that is connected to the view in initView().
		* @see initView();
		*/
	void initDocument();
  /** creates the centerwidget of the KTMainWindow instance and sets it as the view
  	*/
  void initView();
	/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
		* default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
		* be saved if Modified; on cancel the closeEvent is rejected.
		* @see KTMainWindow#queryClose
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryClose();
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
		* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
		* properties.
		* @see KTMainWindow#queryExit
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryExit();
  /** saves the window properties for each open window during session end to the session config file, including saving the currently
		* opened file by a temporary filename provided by KApplication.
   	* @see KTMainWindow#saveProperties
   	*/
  virtual void saveProperties(KConfig* sconfig);
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
		* temporary files saved by saveProperties()
   	* @see KTMainWindow#readProperties
  	*/
  virtual void readProperties(KConfig* sconfig);

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
  void statusCallback(int id_);
  /** open a new application window by creating a new instance of DHLogApp */
  void slotFileNewWindow();
  /** clears the document in the actual view to reuse it as the new document */
  void slotFileNew();
  /** open a file and load it into the document*/
  void slotFileOpen();
	/** opens a file from the recent files menu */
	void slotFileOpenRecent(int id_);
  /** save a document */
  void slotFileSave();
  /** save a document by a new filename*/
  void slotFileSaveAs();
  /** asks for saving if the file is modified, then closes the actual file and window*/
  void slotFileClose();
  /** sorts actual logbook **/
  void slotFileSort();
  /** print the actual file */
  void slotFilePrint();
  /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
  	* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
  	*/
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
    *	it from the document
    */
  void slotEditCut();
  /** put the marked text/object into the clipboard
  	*/
  void slotEditCopy();
  /** paste the clipboard into the document
  	*/
  void slotEditPaste();

  void slotEditDelete();
  void slotEditBeginning();
  void slotEditEnding();
  void slotEditPrev();
  void slotEditNext();
  void slotEditJump();
  void slotEditQso();
  void slotEditCall();

  void slotQslIn();
  void slotQslOut();
  void slotQslSetOut();

  void slotLoggingNew();
	void slotLoggingOnTime();
  /** toggles the toolbar
  	*/
  void slotViewToolBar();
  /** toggles the statusbar
  	*/
  void slotViewStatusBar();
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
  	* @param text the text that is displayed in the statusbar
  	*/
  void slotStatusMsg(const char *text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
  	* @param text the text that is displayed in the statusbar
   	*/
  void slotStatusHelpMsg(const char *text);
  /** enables/disables menu entries in common with the logdocument **/
  void slotEnableMenuEntries();

//signals:
//  void updEnableMenu();	// wird aufgerufen, um Menues passend zu setzen, ob an oder aus...

private:
	/** the configuration object of the application */
	KConfig* config;
	/** the key accelerator container */
	KAccel* key_accel;
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
	/** the recent file menu containing the last five opened files */
	QPopupMenu *recent_files_menu;
	/** contains the recently used filenames */
	QStrList recent_files;
  /** edit_menu contains all items of the menubar entry "Edit" */
  QPopupMenu *edit_menu;
  QPopupMenu *logging_menu;
  QPopupMenu *qsl_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  DHLogView *view;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  DHLogDoc *doc;
	

};
 
#endif // DHLOG_H














































