#include <kapp.h>
#include <klocale.h>
#include "XCarte.h"
#include <qfile.h>
#include <qdstream.h>
#include <qarray.h>
#include <kprocess.h>
#include <qapplication.h>
#include <qfont.h>
#include "define_carte.h"
#include <kapp.h>
#include <kconfig.h>
#include <qmessagebox.h>
#include <kiconloader.h>
#include "super.h"

DEFINITION *tempdef;

XCarte::XCarte(QWidget *parent, const char *name) : QWidget(parent, name) 
{
  QFont f;
  f.setBold(true);
  tempdef=new DEFINITION;

 // setGeometry( 60, 176, 441, 409 );
  KIconLoader IL;
/*pixmap generale*/
	LPixmap = new QLabel ( this, "");
	LPixmap->setGeometry( 20, 20, 40, 40 );
	LPixmap->setPixmap(  IL.loadIcon("carte.xpm" ));
	LPixmap->setAlignment( AlignHCenter | AlignVCenter | ExpandTabs );

/*texte du titre*/
	QLabel *tmp12;
	tmp12 = new QLabel ( this, "");
	tmp12->setCaption( "" );
	tmp12->setGeometry(  70, 25, 165, 29 );
	tmp12->setFont( QFont( "lucidatypewriter", 16, 75, 0));
	tmp12->setText( klocale->translate("Video Card") );
	tmp12->setMargin( -1 );
//	tmp12->setAlignment( AlignLeft | AlignVCenter | ExpandTabs );
	tmp12->setAutoResize( FALSE );

/*liste des constructeur de carte*/
	Vendor = new QListBox ( this, "Vendor");
	Vendor->setGeometry( 12, 156, 189, 211 );
  connect(Vendor, SIGNAL(highlighted ( int )) , SLOT ( slotchangemodele(int)));

/*liste des modele en fonction du constructeur*/
	Modele = new QListBox ( this, "Modele");
	Modele->setGeometry( 204, 156, 219, 211 );
  /*initilisation de la liste avec les valeur generique*/
/*  for (int i =0 ; i <10; i++)
    Modele->insertItem(generique[i].name);
  Modele-> setSelected(0, TRUE);*/
  connect(Modele, SIGNAL(selected(int)), SLOT(slotmodelselected(int)));

/*affichage du rsumer de la selection*/
	QLabel *tmp5;
	tmp5 = new QLabel ( this, "");
	tmp5->setGeometry( 20, 76, 69, 13 );
	tmp5->setText(klocale->translate( "Modele") );
	tmp5->setAlignment( AlignRight | AlignTop | ExpandTabs );
	tmp5->setAutoResize( FALSE );

	QLabel *tmp6;
	tmp6 = new QLabel ( this, "");
	tmp6->setGeometry( 20, 100, 69, 16 );
	tmp6->setText( klocale->translate("Memory") );
	tmp6->setMargin( -1 );
	tmp6->setAlignment( AlignRight | AlignTop | ExpandTabs );
	tmp6->setAutoResize( FALSE );

	QLabel *tmp7;
	tmp7 = new QLabel ( this, "");
	tmp7->setGeometry( 20, 124, 69, 13 );
	tmp7->setText(klocale->translate( "Server") );
	tmp7->setAlignment( AlignRight | AlignTop | ExpandTabs );
	tmp7->setAutoResize( FALSE );

	EdModele = new QLabel ( this, "EdModele" );
	EdModele->setGeometry( 92, 76, 205, 17 );
  EdModele->setPalette(QColor(255,255,255));


	ComboMem = new QComboBox ( this, "ComboMem" );
	ComboMem->setCaption( "" );
	ComboMem->setGeometry( 92, 100, 77, 17 );
	ComboMem->setInsertionPolicy( QComboBox::AtBottom );
	ComboMem->insertItem( "Auto" );
	ComboMem->insertItem( "1024" );
	ComboMem->insertItem( "2048" );
	ComboMem->insertItem( "4096" );
	ComboMem->insertItem( "6324" );
	ComboMem->insertItem( "8192" );


	EdServer = new QLabel ( this, "EdServer" );
	EdServer->setGeometry( 92, 124, 145, 17 );
  EdServer->setPalette(QColor(255,255,255));

/*bouton d'autodetection de la carte*/
	PushAuto = new QPushButton ( this , "");
	PushAuto->setGeometry( 328, 68, 81, 21 );
	PushAuto->setText( klocale->translate("&Autodetect") );
  PushAuto->setFont(f);
  connect (PushAuto, SIGNAL(clicked()), SLOT( slotrunsuperprobe()));

/*lecture de fichier de config */
  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  fichier -> setGroup("Device");
  init_vendor(fichier -> readNumEntry("idVendor", 0));
  Modele->setSelected(fichier -> readNumEntry("idModele", 0), TRUE );
  ComboMem -> setCurrentItem( fichier -> readNumEntry("idMem", 0));
  EdModele->setText(fichier->readEntry("Modele",""));
  EdServer->setText(fichier->readEntry("Server",""));
  delete fichier;
};

XCarte::~XCarte()
{
}



void XCarte::init_vendor(int num)
{
 for (int n=0; n <NB_MAX; n++)
   Vendor -> insertItem(vendeur[n]);
 Vendor-> setSelected(num, TRUE);

}


//il va falloir cetainement modifier ca pour avoir une autre class
// qui gere tout: parce que la ca merde un peut ....
void XCarte::slotrunsuperprobe()
{
  Super super;
  super.exec();

}




/* change les defs pour le constructeur donn */
void XCarte::slotchangemodele(int index)
{
/*suppression des entrees  dans la liste modele */
   Modele->clear();
/* ajoute la liste en fonction du rang*/
   switch(index)
   {
     case 0 :  tempdef=generique;
                break;
     case 1 :   tempdef = asus;
               break;
     case 2 :   tempdef = matrox;
              break;
    }
   for (int n= 0;n <max_def[index]; n++)
        Modele->insertItem( tempdef[n].name);
  Modele->setSelected(0,TRUE);
}

/*insertion des valeur selectionnes dans le resum*/
void XCarte::slotmodelselected(int index)
{
  EdModele->setText(Modele->text(index));
  EdServer->setText( tempdef[index].server);
}



/*enregistrement des selection*/
void XCarte::writeconfig()
{
  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  fichier -> setGroup("Device");
  fichier -> writeEntry("Server", EdServer->text());
  fichier -> writeEntry("Modele",EdModele->text());
  fichier -> writeEntry("Mem",(const char *)ComboMem->currentText());
  fichier -> writeEntry("idVendor",(int)Vendor->currentItem());
  fichier -> writeEntry("idMem",(int)ComboMem->currentItem());
  fichier -> writeEntry("idModele",(int)Modele->currentItem());
  fichier->sync();
  delete fichier;
}






















