/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997 Frithjof Brestrich
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/ 

#ifndef __XF86CFGDATA__
#define __XF86CFGDATA__

#include <qobject.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qstring.h>
#include <qfile.h>
#include <qtstream.h>

#include "xf86vidmode.h"



struct tXF86CfgEntry {
  QString Key;
  QString Value;
  bool    IsString;
}; 

typedef QList<tXF86CfgEntry> tXF86CfgEntryList; 

struct tXF86CfgDirectory {
  tXF86CfgDirectory( const char *name) { 
    Data.setAutoDelete( TRUE ); 
    Dir.setAutoDelete( TRUE ); 
    Name=name; 
  };
  QString                  Name;
  tXF86CfgEntryList        Data;
  QList<tXF86CfgDirectory> Dir;
};

typedef QList<tXF86CfgDirectory> tXF86CfgDirectoryList;


class XF86ConfigFile : public QObject 
{

private:
  const              backupPostfixCharacter = '~';

  QString            ErrorText;
  tXF86CfgDirectory  *Data;
  QFile              *File;
  QTextStream        *Stream;

protected:

  void SetErrorText(const QString &txt);

  bool OpenFile(const QString &fname, int flags);
  bool CloseFile();

  bool BackupFile(const QString &masterfile, const QString &backupfile);

  tXF86CfgEntry* NewCfgEntry(const QString &key, const QString &value, bool isstring);
  bool ReadMonitorModeSection(tXF86CfgDirectory *Dir, const QString &name);
  bool ReadSection(tXF86CfgDirectory *Dir);

  bool WriteSection(tXF86CfgDirectory *Dir, int Deep=0);
  

public:

  XF86ConfigFile();
  virtual ~XF86ConfigFile();

  const QString &LastErrorText();

  bool Load(const QString &fname);
  bool Store(const QString &fname, bool backup = TRUE);

  tXF86CfgDirectory* FindSection(tXF86CfgDirectory* root,
                                 const char* name, unsigned skip = 0);
  tXF86CfgDirectory* FindSection(const char* name, unsigned skip = 0) {
       return FindSection(Data,name,skip);
  }

  tXF86CfgEntry* FindEntry(tXF86CfgEntryList* root,
                           const char* key, const char* value = NULL);
  bool        ExistEntry(tXF86CfgDirectory* root, const char* key, const char* value = NULL);
  bool        RemoveEntry(tXF86CfgDirectory* root, const char* key, const char* value = NULL);
  bool        SetCfgEntry(tXF86CfgDirectory* root, const char* key, const char* value, bool isstring);

  const char* GetValueStr(tXF86CfgDirectory* root, const char* key);
  unsigned    GetValueInt(tXF86CfgDirectory* root, const char* key);
  QList<struct XF86VidSyncRange> GetValueRangeList(tXF86CfgDirectory* root, 
		                                   const char* key, unsigned scale);
  QList<class XF86VidModeLine>  GetValueModelines(tXF86CfgDirectory* root, const char* key);
  bool        SetValueStr(tXF86CfgDirectory* root, const char* key, const char* value);
  bool        SetValueInt(tXF86CfgDirectory* root, const char* key, unsigned    value);
  bool        SetValueRangeList(tXF86CfgDirectory* root, const char* key,
		                QList<struct XF86VidSyncRange> &list, unsigned scale);
  bool        SetValueModelines(tXF86CfgDirectory* root, const char* key, 
		                QList<class XF86VidModeLine> &list);
  

  tXF86CfgDirectory* GetSection(tXF86CfgDirectory* root,
                                const char* section, const char* key, const char* value);
  tXF86CfgDirectory* GetSection(const char* section, const char* key, const char* value) {
      return GetSection(Data,section,key,value);
  };
  tXF86CfgDirectory* GetSection(tXF86CfgDirectory* root, const char* section, const char* key, 
		                unsigned value);
  tXF86CfgDirectory* GetSection(const char* section, const char* key, unsigned value) {
      return GetSection(Data,section,key,value);
  }
  tXF86CfgDirectory* GetMonitorSection(const char* identifier) {
      return GetSection("Monitor","Identifier",identifier);
  }
  tXF86CfgDirectory* GetDeviceSection(const char* identifier) {
      return GetSection("Device","Identifier",identifier);
  }

  bool GetScreenSections(tXF86CfgDirectoryList &list,
                         const char* vendor = NULL, const char* model = NULL);

//  bool GetScreenNames(QStrList &driverlist, QStrList &devicelist, QStrList &monitorlist,
//                      const char* vendor = NULL, const char* model = NULL);

//  bool SetModeLines(char *vendor, char *model, XF86VidModeLine* &modelines, unsigned count);
};

/* // TODO: DELETE ME ON A RAINY DAY
class XF86Config : public QObject{

protected:

  XF86ConfigFile     *db;

  tXF86CfgDirectory  *screenSection;
  tXF86CfgDirectory  *deviceSection;
  tXF86CfgDirectory  *monitorSection;

public:
  
  XF86Config();
  virtual ~XF86Config();

  virtual void setDB(XF86ConfigFile *cfg) { db = cfg;  };
  virtual XF86ConfigFile *getDB()         { return db; };

};
*/
#endif /* __XF86CFGDATA__ */
