    /*

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997 Frithjof Brestrich
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include "kvidtune.h"

#include <qapp.h>
#include <kmenubar.h>
#include <kapp.h> 
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kpanner.h>
#include <ktabctl.h>

#include "xf86vidmode.h"
#include "kvidtunecfg.h"
#include "kviddata.h"
#include "dlgadvancedxstartup.h"
#include "dlginfomonitor.h"
#include "dlginfoxserver.h"

class TopLevel : public KTopLevelWidget
{
  Q_OBJECT;
  
public:

  TopLevel(KVidData *data);
  ~TopLevel();

  void setupContent();
  void updateContent();

protected:
  QPopupMenu    *menu_file;
  QPopupMenu    *menu_mode;
  QPopupMenu    *menu_info;
  QPopupMenu    *menu_settings;
  QPopupMenu    *menu_help;

  XF86VidMode     *VidMode;
  XF86VidModeLine *VML_Akt, *VML_Undo, *VML_Restore;
  bool            LifeAdjust;

  KVidData        *vidData;
  KVidTuneCfg     *Cfg;

  void createMenuBar();
  void createToolBar();
  void createStatusBar();
  void createMainWidget();

  QWidget *createTabVideoMode(QWidget *parent);
  QWidget *createTabCompose(QWidget *parent);
  QWidget *createTabXStartup(QWidget *parent);
  QWidget *createTabMonitor(QWidget *parent);
  QWidget *createTabX11(QWidget *parent);
  QWidget *createTabOptions(QWidget *parent);

  void setupTabVideoMode();
  void setupTabCompose();
  void setupTabXStartup();
  void setupTabMonitor();
  void setupTabX11();
  void setupTabOptions();

  void ProcessStatus(const char *topic, bool msgbox = TRUE);
  void ProcessStatus(const char *topic, const char *msg, bool msgbox = TRUE);

  void displayWarning();

  void update_modeinfo();

  bool vidcmd_apply( bool doit = FALSE );

private:

  KMenuBar   *menubar;
  KToolBar   *toolbar;
  KStatusBar *statusbar;

  KTabCtl    *tabctl;
  KVidTune   *vidtune;
  DlgAdvancedXStartup *tabXStartup;
  DlgInfoMonitor      *tabMonitor;
  DlgInfoXServer      *tabXServer;

  int   menu_item_save;

  const int ID_STATUS_GENERAL = 1;
  const int ID_TOOLBAR_SAVE   = 2;

public slots:

  void videomode(int mode);
  void vidcmd_lifeadj(bool state);

  void vidmov_left(int steps);
  void vidmov_right(int steps);
  void vidmov_up(int steps);
  void vidmov_down(int steps);
  void vidsiz_hmore(int steps);
  void vidsiz_hless(int steps);
  void vidsiz_vmore(int steps);
  void vidsiz_vless(int steps);

  void vidflg_interlace(bool state);
  void vidflg_doublescan(bool state);
  void vidflg_composite(bool state);
  void vidflg_phsync(bool state);
  void vidflg_nhsync(bool state);
  void vidflg_pvsync(bool state);
  void vidflg_nvsync(bool state);
  void vidflg_pcsync(bool state);
  void vidflg_ncsync(bool state);

  void vidcmd_details();
  void vidcmd_modeline();

  void vidcmd_undo();
  void vidcmd_test();
  void vidcmd_restore();

  void filesave();

  void prevvideomode();
  void nextvideomode();

  void settingsconfigure();

  void about();
  void aboutQt();
  void help();

};

#endif
