    /*

    Requires the Qt widget libraries, available at no cost at 
    http://www.troll.no
       
    Copyright (C) 1997 Frithjof Brestrich 
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */
 
#include "toplevel.h"
#include "xf86vidmode.h"

#include <kapp.h>
#include <kmsgbox.h>

#include "dlgconfiglocation.h"
#include "dlgconfigselection.h"
#include "kviddata.h"
#include "kvidtunecfg.h"

#include "xf86configfile.h"

XF86VidMode *bootXF86VMode()
{
  XF86VidMode  *VidMode;
  
  VidMode = new XF86VidMode();
  
  if (!VidMode) {
    KMsgBox::message(NULL,
                     klocale->translate("KVidTune - Fatal error"), 
                     klocale->translate("Cannot create XF86VidMode object (not enough memory)."),
		     KMsgBox::STOP, klocale->translate("&Terminate"));
  }
  if (!VidMode->ConnectDisplay(kapp->getDisplay(),DefaultScreen(kapp->getDisplay()))) {
    QString txt;
    txt = klocale->translate("Cannot initialise XFree86-VidModeExtension.\n"
                             "Version number must be 0.5 or greater.\n\n"
                             "Given reason:\n");
    txt += klocale->translate(VidMode->LastErrorText());
    KMsgBox::message(NULL,klocale->translate("KVidTune - Fatal error"), txt,
		     KMsgBox::STOP, klocale->translate("&Terminate"));
    delete VidMode;
    return NULL;
  }
  if (!VidMode->RequestData()) {
    QString txt;
    txt = klocale->translate("Cannot receive XFree86-VidModeExtension data.\n\n"
                             "Given reason:\n");
    txt += klocale->translate(VidMode->LastErrorText());
    KMsgBox::message(NULL,klocale->translate("KVidTune - Fatal error"), txt,
		     KMsgBox::STOP, klocale->translate("&Terminate"));
    delete VidMode;
    return NULL;
  }

  return VidMode;
}

bool WarningDlg(QWidget * parent)
{
  return KMsgBox::yesNo(parent, klocale->translate("WARNING  WARNING  WARNING  WARNING"),
                 klocale->translate(
                   "THE INCORRECT USE OF THIS PROGRAM CAN DO PERMANENT DAMAGE TO YOUR MONITOR\n"
                   "AND/OR VIDEO CARD.  IF YOU ARE NOT SURE WHAT YOU ARE DOING, HIT ABORT\n"
                   "NOW. OTHERWISE, HIT CONTINUE\n"
                   "\n"
                   "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
                   "EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
                   "MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
                   "SEE THE \"GNU General Public License\" FOR MORE DETAILS.\n"
                   "\n"
                   "IN NO EVENT SHALL Frithjof Brestrich BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
		   "LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\n"
                   "FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n"
		   "DEALINGS IN THE SOFTWARE."),
                 KMsgBox::EXCLAMATION|KMsgBox::DB_SECOND,
                 klocale->translate("&Continue"),
                 klocale->translate("&Abort"))==1;
}

bool CheckIfDisplayIsLocal(QWidget * parent, KVidTuneCfg *cfg)
{
    if (  ( cfg->displayName == ":0.0" ) 
       || ( cfg->displayName == ":0" ) 
       || ( cfg->displayName == "localhost:0.0" )
       || ( cfg->displayName == "localhost:0" ) 
       || ( cfg->displayName == cfg->hostName+":0.0" ) 
       || ( cfg->displayName == cfg->hostName+":0" ) )
    { 
        return TRUE;
    }
    return KMsgBox::yesNo(parent,klocale->translate("Local display"), 
    	                  klocale->translate("The display (")+cfg->displayName+klocale->translate(") does not seem to be a local display.\n"
			     "Because the configuration file for the display resists on an \n"
			     "different host (display host) it may not be accessible for the \n"
			     "execution host. This prevents a proper operation of this program."),
                          KMsgBox::QUESTION|KMsgBox::DB_SECOND, 
                          klocale->translate("&Continue"),
                          klocale->translate("&Abort"))==1;
}

bool AskConfigurationInformation(QWidget * parent, KVidData *data)
{
    DlgConfigLocation  fdlg(parent);
    DlgConfigSelection sdlg(parent);
    QStrList           driver, device, monitor;

    while ( TRUE ) {
        while ( TRUE )  {

            fdlg.SetFile(data->vidCfg->cfgWorkingDirectory,data->vidCfg->cfgConfigFile);
            if ( fdlg.exec() != 1 )
                return FALSE;
            fdlg.GetFile(data->vidCfg->cfgWorkingDirectory,data->vidCfg->cfgConfigFile);
            
            if ( !data->loadXf86Config(data->vidCfg->cfgConfigFile) ) {
                KMsgBox::message(parent,klocale->translate("KVidTune - configuration error"), 
        	                 data->xf86cfg->LastErrorText(),
        		         KMsgBox::STOP, klocale->translate("&OK"));
	        continue;
	    }

            if (!  data->getXF86DriverList(driver,device,monitor) ) {
	        KMsgBox::message(parent,klocale->translate("KVidTune - configuration error"),
		                 data->LastErrorText(),KMsgBox::STOP, klocale->translate("&OK")); 
	        continue;
	    }

	    break;
	}
            
        sdlg.FillLabels(driver,device,monitor,0);
        if ( sdlg.exec() == 1 ) {
	    data->setXF86Driver(sdlg.GetSelected());
	} else
	    continue;

        break;
    }
    
    
    return TRUE;
}

int main( int argc, char *argv[] )
{
  KVidData    *vidData;
  TopLevel    *toplevel;

  KApplication a( argc, argv, "kvidtune" );
  
  vidData = new KVidData;
  vidData->loadConfig();

  vidData->xf86vid = bootXF86VMode();

  toplevel = new TopLevel(vidData);
  toplevel->setUnsavedData(TRUE);
  kapp->setMainWidget(toplevel); 

  if ( vidData->vidCfg->cfgDisplayWarning ) {
     if ( !WarningDlg(toplevel) ) 
       return 1;
  }

  if ( vidData->vidCfg->cfgWarnIfNotLocal ) {
    if ( !CheckIfDisplayIsLocal(toplevel,vidData->vidCfg) )
       return 1;
  }

  if ( vidData->vidCfg->cfgNeedConfigInfo ) 
    AskConfigurationInformation(toplevel,vidData);

  vidData->syncRunningWithStartup();

  toplevel->setupContent();
    
  kapp->exec();
  
  vidData->storeConfig();

  delete vidData;

  return 0;
}
